/*
 * Decompiled with CFR 0.152.
 */
package com.georgirim.mwveddingshop.utils;

import com.georgirim.mwveddingshop.utils.ModelWrapperDisplayList;
import georgi.kotiln.jvm.functions.Function2;
import georgi.kotiln.jvm.internal.Intrinsics;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;

@GradleSideOnly(value={GradleSide.CLIENT})
public final class ModelWrapperDisplayList
implements IModelCustom {
    @NotNull
    private final Map<String, Integer> lists;
    @NotNull
    private final IntBuffer bufAll;
    @NotNull
    private final String type;

    public ModelWrapperDisplayList(@NotNull WavefrontObject model) {
        Intrinsics.checkNotNullParameter(model, "model");
        this.lists = new HashMap();
        String string = model.getType();
        Intrinsics.checkNotNullExpressionValue(string, "getType(...)");
        this.type = string;
        int list = GL11.glGenLists((int)model.groupObjects.size());
        for (GroupObject obj : model.groupObjects) {
            String string2;
            GL11.glNewList((int)list, (int)4864);
            model.renderPart(obj.name);
            GL11.glEndList();
            Map<String, Integer> map = this.lists;
            Intrinsics.checkNotNullExpressionValue(obj.name, "name");
            Integer n = list++;
            map.put(string2, n);
        }
        this.bufAll = this.initBuffer();
    }

    private final IntBuffer initBuffer() {
        IntBuffer buf = BufferUtils.createIntBuffer((int)this.lists.size());
        Iterator<Integer> iterator2 = this.lists.values().iterator();
        while (iterator2.hasNext()) {
            int i = ((Number)iterator2.next()).intValue();
            buf.put(i);
        }
        buf.flip();
        Intrinsics.checkNotNull(buf);
        return buf;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public void renderAll() {
        GL11.glCallLists((IntBuffer)this.bufAll);
    }

    public void renderOnly(String ... groupNames) {
        Intrinsics.checkNotNullParameter(groupNames, "groupNames");
        if (groupNames.length == 0) {
            return;
        }
        for (String group : groupNames) {
            this.renderPart(group);
        }
    }

    public void renderPart(@NotNull String partName) {
        Intrinsics.checkNotNullParameter(partName, "partName");
        Integer list = this.lists.get(partName);
        if (list != null) {
            GL11.glCallList((int)list);
        }
    }

    public void renderAllExcept(String ... groupNames) {
        Intrinsics.checkNotNullParameter(groupNames, "groupNames");
        if (groupNames.length == 0) {
            this.renderAll();
            return;
        }
        for (Map.Entry<String, Integer> entry : this.lists.entrySet()) {
            String key = entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            if (Arrays.binarySearch(groupNames, key, (arg_0, arg_1) -> ModelWrapperDisplayList.renderAllExcept$lambda$0(renderAllExcept.1.INSTANCE, arg_0, arg_1)) >= 0) continue;
            GL11.glCallList((int)value);
        }
    }

    private static final int renderAllExcept$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

