/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.thaumcraftneiplugin.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import com.djgiannuzz.thaumcraftneiplugin.ModItems;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.wands.ItemWandCasting;

public class NEIHelper {
    public static Object[] fillSpaces(Object[] input) {
        Object[] in = new Object[9];
        if (input.length < 9) {
            for (int i = 0; i < 9; ++i) {
                in[i] = i < input.length ? input[i] : null;
            }
            return in;
        }
        return input;
    }

    public static void addAspectsToIngredients(AspectList aspects, List<PositionedStack> ingredients, int type) {
        int i = 0;
        int x = 42;
        int y = 115;
        int aspectsPerRow = 9;
        int rows = aspects.size() / aspectsPerRow;
        int shift = (5 - aspects.size() % aspectsPerRow) * 10;
        int m = 0;
        for (Aspect aspect : aspects.getAspectsSortedAmount()) {
            ItemStack stack = new ItemStack(ModItems.itemAspect, 1, 1);
            ItemAspect.setAspect(stack, aspect);
            int xx = x;
            int yy = y;
            switch (type) {
                case 0: {
                    xx = x + 18 * i + (5 - aspects.size()) * 8;
                    break;
                }
                case 1: {
                    xx = x - 7;
                    yy = y - 10 * rows - 1;
                    if (i / aspectsPerRow >= rows && (rows > 1 || aspects.size() < aspectsPerRow)) {
                        m = 1;
                    }
                    xx += i % aspectsPerRow * 20 + shift * m;
                    yy += i / aspectsPerRow * 20;
                    break;
                }
                case 2: {
                    rows = (aspects.aspects.size() - 1) / 3;
                    shift = (3 - aspects.aspects.size() % 3) * 10;
                    int sx = x + 9;
                    int sy = y - 36 - 10 * rows;
                    if (i / 3 >= rows && (rows > 1 || aspects.aspects.size() < 3)) {
                        m = 1;
                    }
                    xx = sx + i % 3 * 20 + shift * m;
                    yy = sy + i / 3 * 20;
                    break;
                }
            }
            ingredients.add(new PositionedStack((Object)stack, xx, yy, false));
            ++i;
        }
    }

    private static void renderAspect(int x, int y, Aspect aspect, int amount) {
        UtilsFX.drawTag((int)x, (int)y, (Aspect)aspect, (float)amount, (int)0, (double)GuiDraw.gui.getZLevel());
    }

    public static AspectList getPrimalAspectListFromAmounts(int[] amounts) {
        AspectList aspects = new AspectList();
        int i = 0;
        for (int amount : amounts) {
            if (amount > 0) {
                aspects.add((Aspect)Aspect.getPrimalAspects().get(i), amount);
            }
            ++i;
        }
        return aspects;
    }

    public static void drawAspectsArcane(int[] amounts) {
        int i = 0;
        int x = 42;
        int y = 115;
        AspectList aspects = NEIHelper.getPrimalAspectListFromAmounts(amounts);
        for (Aspect tag : aspects.getAspectsSortedAmount()) {
            NEIHelper.renderAspect(x + 18 * i + (5 - aspects.size()) * 8, y, tag, aspects.getAmount(tag));
            ++i;
        }
    }

    public static Object[] fillSpaces(ArrayList array) {
        Object[] input = array.toArray();
        return NEIHelper.fillSpaces(input);
    }

    public static ItemStack getAssociatedItemStack(Object o) {
        ArrayList list;
        ItemStack stack = null;
        if (o instanceof ItemStack) {
            stack = (ItemStack)o;
            if (stack.func_77960_j() == Short.MAX_VALUE && stack.func_77973_b().func_77614_k()) {
                ArrayList list2 = new ArrayList();
                stack.func_77973_b().func_150895_a(stack.func_77973_b(), stack.func_77973_b().func_77640_w(), list2);
                if (list2 != null && list2.size() > 0) {
                    int meta = (int)(System.currentTimeMillis() / 1000L % (long)list2.size());
                    ItemStack temp = new ItemStack(stack.func_77973_b(), 1, meta);
                    temp.func_77982_d(stack.func_77978_p());
                    stack = temp;
                }
            } else if (stack.func_77960_j() == Short.MAX_VALUE && stack.func_77984_f()) {
                int meta = (int)(System.currentTimeMillis() / 10L % (long)stack.func_77958_k());
                ItemStack t = new ItemStack(stack.func_77973_b(), 1, meta);
                t.func_77982_d(stack.func_77978_p());
                stack = t;
            }
        } else if (o instanceof ArrayList) {
            ArrayList list3 = (ArrayList)o;
            if (list3 != null && list3.size() > 0) {
                int index = (int)(System.currentTimeMillis() / 1000L % (long)list3.size());
                stack = NEIHelper.getAssociatedItemStack(list3.get(index));
            }
        } else if (o instanceof String && (list = OreDictionary.getOres((String)((String)o))) != null && list.size() > 0) {
            int idx = (int)(System.currentTimeMillis() / 1000L % (long)list.size());
            stack = NEIHelper.getAssociatedItemStack(list.get(idx));
        }
        return stack;
    }

    public static Object[] buildWandInput(WandRod rod, WandCap cap) {
        Object[] array = new Object[9];
        array[2] = cap.getItem();
        array[6] = cap.getItem();
        array[4] = rod.getItem();
        return array;
    }

    public static Object[] buildScepterInput(WandRod rod, WandCap cap) {
        Object[] array = new Object[9];
        array[1] = cap.getItem();
        array[2] = new ItemStack(ConfigItems.itemResource, 1, 15);
        array[5] = cap.getItem();
        array[4] = rod.getItem();
        array[6] = cap.getItem();
        return array;
    }

    public static int[] getWandAspectsWandCost(ItemStack stack) {
        int[] al = new int[Aspect.getPrimalAspects().size()];
        ItemWandCasting wand = null;
        if (!(stack.func_77973_b() instanceof ItemWandCasting)) {
            return null;
        }
        wand = (ItemWandCasting)stack.func_77973_b();
        int cc = -1;
        int cr = -1;
        ItemStack cap = wand.getCap(stack).getItem();
        ItemStack rod = wand.getRod(stack).getItem();
        if (cap != null && rod != null) {
            for (WandCap wc : WandCap.caps.values()) {
                if (!NEIHelper.checkItemEquals(cap, wc.getItem())) continue;
                cc = wc.getCraftCost();
                break;
            }
            for (WandRod wr : WandRod.rods.values()) {
                if (!NEIHelper.checkItemEquals(rod, wr.getItem())) continue;
                cr = wr.getCraftCost();
                break;
            }
            if (cc >= 0 && cr >= 0) {
                int cost = cc * cr;
                for (int i = 0; i < al.length; ++i) {
                    al[i] = cost;
                }
            }
        }
        return al;
    }

    private static boolean checkItemEquals(ItemStack target, ItemStack input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return !(target.func_77973_b() != input.func_77973_b() || target.func_77942_o() && !ItemStack.func_77970_a((ItemStack)target, (ItemStack)input) || target.func_77960_j() != Short.MAX_VALUE && target.func_77960_j() != input.func_77960_j());
    }
}

