/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.recipe.CatalystInfo;
import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class CatalystInfoList
extends ForwardingList<CatalystInfo> {
    private final String handlerID;
    private final List<CatalystInfo> catalystInfoList = new ArrayList<CatalystInfo>();

    public CatalystInfoList(String handlerID) {
        this.handlerID = handlerID;
    }

    public CatalystInfoList(String handlerID, CatalystInfo catalystInfo) {
        this(handlerID);
        this.add(catalystInfo);
    }

    protected List<CatalystInfo> delegate() {
        return this.catalystInfoList;
    }

    public boolean add(@Nonnull CatalystInfo catalystInfo) {
        if (this.contains(catalystInfo)) {
            NEIClientConfig.logger.info(String.format("catalyst %s is already registered to handler %s", catalystInfo.getStack().func_82833_r(), this.handlerID));
            return false;
        }
        super.add((Object)catalystInfo);
        return true;
    }

    public boolean contains(Object object) {
        if (object instanceof CatalystInfo) {
            ItemStack stack = ((CatalystInfo)object).getStack();
            return this.contains(stack);
        }
        return false;
    }

    public boolean contains(ItemStack stack) {
        return this.catalystInfoList.stream().anyMatch(c -> NEIServerUtils.areStacksSameTypeCraftingWithNBT(c.getStack(), stack));
    }

    public boolean remove(ItemStack stack) {
        Iterator<CatalystInfo> iter = this.catalystInfoList.iterator();
        while (iter.hasNext()) {
            ItemStack next = iter.next().getStack();
            if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT(next, stack)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public void sort() {
        super.sort((c1, c2) -> c2.getPriority() - c1.getPriority());
    }
}

