/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashSet;
import java.util.Set;

public class DynamicLight {
    private sa entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private boolean underwater = false;
    private long timeCheckMs = 0L;
    private Set<BlockPos> setLitChunkPos = new HashSet<BlockPos>();

    public DynamicLight(sa entity) {
        this.entity = entity;
        this.offsetY = entity.g();
    }

    public void update(bma renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.s - 0.5;
        double posY = this.entity.t - 0.5 + this.offsetY;
        double posZ = this.entity.u - 0.5;
        int lightLevel = DynamicLights.getLightLevel(this.entity);
        double dx = posX - this.lastPosX;
        double dy2 = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy2) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        this.underwater = false;
        bjf world = renderGlobal.r;
        if (world != null) {
            aji block = world.a(qh.c(posX), qh.c(posY), qh.c(posZ));
            this.underwater = block == ajn.j;
        }
        HashSet<BlockPos> setNewPos = new HashSet<BlockPos>();
        if (lightLevel > 0) {
            cr dirX = (qh.c(posX) & 0xF) >= 8 ? cr.e : cr.f;
            cr dirY = (qh.c(posY) & 0xF) >= 8 ? cr.b : cr.a;
            cr dirZ = (qh.c(posZ) & 0xF) >= 8 ? cr.d : cr.c;
            dirX = this.getOpposite(dirX);
            BlockPos pos = new BlockPos(qh.c(posX), qh.c(posY), qh.c(posZ));
            BlockPos chunkView = new BlockPos(qh.a(pos.getX(), 16) * 16, qh.a(pos.getY(), 16) * 16, qh.a(pos.getZ(), 16) * 16);
            BlockPos chunkX = DynamicLight.getRenderChunk(chunkView, dirX);
            BlockPos chunkZ = DynamicLight.getRenderChunk(chunkView, dirZ);
            BlockPos chunkXZ = DynamicLight.getRenderChunk(chunkX, dirZ);
            BlockPos chunkY = DynamicLight.getRenderChunk(chunkView, dirY);
            BlockPos chunkYX = DynamicLight.getRenderChunk(chunkY, dirX);
            BlockPos chunkYZ = DynamicLight.getRenderChunk(chunkY, dirZ);
            BlockPos chunkYXZ = DynamicLight.getRenderChunk(chunkYX, dirZ);
            this.updateChunkLight(renderGlobal, chunkView, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private cr getOpposite(cr facing) {
        switch (facing) {
            case a: {
                return cr.b;
            }
            case b: {
                return cr.a;
            }
            case c: {
                return cr.d;
            }
            case d: {
                return cr.c;
            }
            case e: {
                return cr.f;
            }
            case f: {
                return cr.e;
            }
        }
        return cr.a;
    }

    private static BlockPos getRenderChunk(BlockPos pos, cr facing) {
        return new BlockPos(pos.getX() + facing.c() * 16, pos.getY() + facing.d() * 16, pos.getZ() + facing.e() * 16);
    }

    private void updateChunkLight(bma renderGlobal, BlockPos pos, Set<BlockPos> setPrevPos, Set<BlockPos> setNewPos) {
        if (pos == null) {
            return;
        }
        renderGlobal.a(pos.getX() + 8, pos.getY() + 8, pos.getZ() + 8);
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(bma renderGlobal) {
        for (BlockPos posOld : this.setLitChunkPos) {
            this.updateChunkLight(renderGlobal, posOld, null, null);
        }
    }

    public sa getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public boolean isUnderwater() {
        return this.underwater;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

