/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;

public class DynamicLights {
    private static DynamicLightsMap mapDynamicLights = new DynamicLightsMap();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;
    private static ReflectorField ItemBlock_block = Reflector.getReflectorField(abh.class, aji.class);

    public static void entityAdded(sa entityIn, bma renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(sa entityIn, bma renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLight dynamicLight = mapDynamicLights.remove(entityIn.y());
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(bma renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLights.updateMapDynamicLights(renderGlobal);
            if (mapDynamicLights.size() <= 0) {
                return;
            }
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i2 = 0; i2 < dynamicLights.size(); ++i2) {
                DynamicLight dynamicLight = dynamicLights.get(i2);
                dynamicLight.update(renderGlobal);
            }
        }
    }

    private static void updateMapDynamicLights(bma renderGlobal) {
        bjf world = renderGlobal.r;
        if (world == null) {
            return;
        }
        List entities = world.D();
        for (sa entity : entities) {
            DynamicLight dynamicLight;
            int key;
            int lightLevel = DynamicLights.getLightLevel(entity);
            if (lightLevel > 0) {
                key = entity.y();
                dynamicLight = mapDynamicLights.get(key);
                if (dynamicLight != null) continue;
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, dynamicLight);
                continue;
            }
            key = entity.y();
            dynamicLight = mapDynamicLights.remove(key);
            if (dynamicLight == null) continue;
            dynamicLight.updateLitChunks(renderGlobal);
        }
    }

    public static int getCombinedLight(int x, int y, int z, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(x, y, z);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(sa entity, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(entity);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(int x, int y, int z) {
        double lightLevelMax = 0.0;
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i2 = 0; i2 < dynamicLights.size(); ++i2) {
                double dist;
                double light;
                double lightLevel;
                DynamicLight dynamicLight = dynamicLights.get(i2);
                int dynamicLightLevel = dynamicLight.getLastLightLevel();
                if (dynamicLightLevel <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz2 = dynamicLight.getLastPosZ();
                double dx = (double)x - px;
                double dy2 = (double)y - py;
                double dz = (double)z - pz2;
                double distSq = dx * dx + dy2 * dy2 + dz * dz;
                if (dynamicLight.isUnderwater() && !Config.isClearWater()) {
                    dynamicLightLevel = Config.limit(dynamicLightLevel - 2, 0, 15);
                    distSq *= 2.0;
                }
                if (distSq > 56.25 || !((lightLevel = (light = 1.0 - (dist = Math.sqrt(distSq)) / 7.5) * (double)dynamicLightLevel) > lightLevelMax)) continue;
                lightLevelMax = lightLevel;
            }
        }
        double lightPlayer = Config.limit(lightLevelMax, 0.0, 15.0);
        return lightPlayer;
    }

    public static int getLightLevel(add itemStack) {
        abh itemBlock;
        aji block;
        if (itemStack == null) {
            return 0;
        }
        adb item = itemStack.b();
        if (item instanceof abh && (block = (aji)Reflector.getFieldValue(itemBlock = (abh)item, ItemBlock_block)) != null) {
            return block.m();
        }
        if (item == ade.at) {
            return ajn.l.m();
        }
        if (item == ade.bj || item == ade.br) {
            return 10;
        }
        if (item == ade.aO) {
            return 8;
        }
        if (item == ade.bs) {
            return 8;
        }
        if (item == ade.bN) {
            return ajn.bJ.m() / 2;
        }
        return 0;
    }

    public static int getLightLevel(sa entity) {
        xz entityCreeper;
        if (entity == Config.getMinecraft().i && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity.al()) {
            return 15;
        }
        if (entity instanceof ze) {
            return 15;
        }
        if (entity instanceof xw) {
            return 15;
        }
        if (entity instanceof xx) {
            xx entityBlaze = (xx)entity;
            if (entityBlaze.bZ()) {
                return 15;
            }
            return 10;
        }
        if (entity instanceof yf) {
            yf emc = (yf)entity;
            if ((double)emc.i > 0.6) {
                return 13;
            }
            return 8;
        }
        if (entity instanceof xz && (entityCreeper = (xz)entity).cb() > 0) {
            return 15;
        }
        if (entity instanceof sv) {
            sv player = (sv)entity;
            add stackMain = player.be();
            int levelMain = DynamicLights.getLightLevel(stackMain);
            add stackHead = player.q(4);
            int levelHead = DynamicLights.getLightLevel(stackHead);
            return Math.max(levelMain, levelHead);
        }
        if (entity instanceof xk) {
            xk entityItem = (xk)entity;
            add itemStack = DynamicLights.getItemStack(entityItem);
            return DynamicLights.getLightLevel(itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(bma renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i2 = 0; i2 < dynamicLights.size(); ++i2) {
                DynamicLight dynamicLight = dynamicLights.get(i2);
                dynamicLight.updateLitChunks(renderGlobal);
            }
            dynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            return mapDynamicLights.size();
        }
    }

    public static add getItemStack(xk entityItem) {
        add itemstack = entityItem.z().f(10);
        return itemstack;
    }
}

