/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ReflectorMethod {
    private ReflectorClass reflectorClass = null;
    private String targetMethodName = null;
    private Class[] targetMethodParameterTypes = null;
    private boolean checked = false;
    private Method targetMethod = null;

    public ReflectorMethod(ReflectorClass reflectorClass, String targetMethodName) {
        this(reflectorClass, targetMethodName, null, false);
    }

    public ReflectorMethod(ReflectorClass reflectorClass, String targetMethodName, Class[] targetMethodParameterTypes) {
        this(reflectorClass, targetMethodName, targetMethodParameterTypes, false);
    }

    public ReflectorMethod(ReflectorClass reflectorClass, String targetMethodName, Class[] targetMethodParameterTypes, boolean lazyResolve) {
        this.reflectorClass = reflectorClass;
        this.targetMethodName = targetMethodName;
        this.targetMethodParameterTypes = targetMethodParameterTypes;
        if (!lazyResolve) {
            Method m = this.getTargetMethod();
        }
    }

    public Method getTargetMethod() {
        if (this.checked) {
            return this.targetMethod;
        }
        this.checked = true;
        Class cls = this.reflectorClass.getTargetClass();
        if (cls == null) {
            return null;
        }
        try {
            if (this.targetMethodParameterTypes == null) {
                Method[] ms2 = ReflectorMethod.getMethods(cls, this.targetMethodName);
                if (ms2.length <= 0) {
                    Config.log("(Reflector) Method not present: " + cls.getName() + "." + this.targetMethodName);
                    return null;
                }
                if (ms2.length > 1) {
                    Config.warn("(Reflector) More than one method found: " + cls.getName() + "." + this.targetMethodName);
                    for (int i2 = 0; i2 < ms2.length; ++i2) {
                        Method m = ms2[i2];
                        Config.warn("(Reflector)  - " + m);
                    }
                    return null;
                }
                this.targetMethod = ms2[0];
            } else {
                this.targetMethod = ReflectorMethod.getMethod(cls, this.targetMethodName, this.targetMethodParameterTypes);
            }
            if (this.targetMethod == null) {
                Config.log("(Reflector) Method not present: " + cls.getName() + "." + this.targetMethodName);
                return null;
            }
            this.targetMethod.setAccessible(true);
            return this.targetMethod;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public boolean exists() {
        if (this.checked) {
            return this.targetMethod != null;
        }
        return this.getTargetMethod() != null;
    }

    public Class getReturnType() {
        Method tm = this.getTargetMethod();
        if (tm == null) {
            return null;
        }
        return tm.getReturnType();
    }

    public void deactivate() {
        this.checked = true;
        this.targetMethod = null;
    }

    public static Method getMethod(Class cls, String methodName, Class[] paramTypes) {
        Method[] ms2 = cls.getDeclaredMethods();
        for (int i2 = 0; i2 < ms2.length; ++i2) {
            Class[] types;
            Method m = ms2[i2];
            if (!m.getName().equals(methodName) || !Reflector.matchesTypes(paramTypes, types = m.getParameterTypes())) continue;
            return m;
        }
        return null;
    }

    public static Method[] getMethods(Class cls, String methodName) {
        ArrayList<Method> listMethods = new ArrayList<Method>();
        Method[] ms2 = cls.getDeclaredMethods();
        for (int i2 = 0; i2 < ms2.length; ++i2) {
            Method m = ms2[i2];
            if (!m.getName().equals(methodName)) continue;
            listMethods.add(m);
        }
        Method[] methods = listMethods.toArray(new Method[listMethods.size()]);
        return methods;
    }
}

