/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;

public class WrUpdaterThreaded
implements IWrUpdater {
    private WrUpdateThread updateThread = null;
    private float timePerUpdateMs = 10.0f;
    private long updateStartTimeNs = 0L;
    private boolean firstUpdate = true;
    private int updateTargetNum = 0;

    @Override
    public void terminate() {
        if (this.updateThread == null) {
            return;
        }
        this.updateThread.terminate();
        this.updateThread.unpauseToEndOfUpdate();
    }

    @Override
    public void initialize() {
    }

    private void delayedInit() {
        if (this.updateThread != null) {
            return;
        }
        this.createUpdateThread(Display.getDrawable());
    }

    @Override
    public blo makeWorldRenderer(ahb worldObj, List tileEntities, int x, int y, int z, int glRenderListBase) {
        return new WorldRendererThreaded(worldObj, tileEntities, x, y, z, glRenderListBase);
    }

    public WrUpdateThread createUpdateThread(Drawable displayDrawable) {
        if (this.updateThread != null) {
            throw new IllegalStateException("UpdateThread is already existing");
        }
        try {
            Pbuffer pbuffer = new Pbuffer(1, 1, new PixelFormat(), displayDrawable);
            this.updateThread = new WrUpdateThread(pbuffer);
            this.updateThread.setPriority(1);
            this.updateThread.start();
            this.updateThread.pause();
            return this.updateThread;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public boolean isUpdateThread() {
        return Thread.currentThread() == this.updateThread;
    }

    public static boolean isBackgroundChunkLoading() {
        return true;
    }

    @Override
    public void preRender(bma rg2, sv player) {
        this.updateTargetNum = 0;
        if (this.updateThread != null) {
            if (this.updateStartTimeNs == 0L) {
                this.updateStartTimeNs = System.nanoTime();
            }
            if (this.updateThread.hasWorkToDo()) {
                this.updateTargetNum = Config.getUpdatesPerFrame();
                if (Config.isDynamicUpdates() && !rg2.isMoving(player)) {
                    this.updateTargetNum *= 3;
                }
                this.updateTargetNum = Math.min(this.updateTargetNum, this.updateThread.getPendingUpdatesCount());
                if (this.updateTargetNum > 0) {
                    this.updateThread.unpause();
                }
            }
        }
    }

    @Override
    public void postRender() {
        if (this.updateThread != null) {
            float sleepTimeMs = 0.0f;
            if (this.updateTargetNum > 0) {
                long renderTimeNs = System.nanoTime() - this.updateStartTimeNs;
                float targetRunTime = this.timePerUpdateMs * (1.0f + (float)(this.updateTargetNum - 1) / 2.0f);
                sleepTimeMs = targetRunTime;
                if (sleepTimeMs > 0.0f) {
                    int sleepTimeMsInt = (int)sleepTimeMs;
                    Config.sleep(sleepTimeMsInt);
                }
                this.updateThread.pause();
            }
            float deltaTime = 0.2f;
            if (this.updateTargetNum > 0) {
                int updateCount = this.updateThread.resetUpdateCount();
                if (updateCount < this.updateTargetNum) {
                    this.timePerUpdateMs += deltaTime;
                }
                if (updateCount > this.updateTargetNum) {
                    this.timePerUpdateMs -= deltaTime;
                }
                if (updateCount == this.updateTargetNum) {
                    this.timePerUpdateMs -= deltaTime;
                }
            } else {
                this.timePerUpdateMs -= deltaTime / 5.0f;
            }
            if (this.timePerUpdateMs < 0.0f) {
                this.timePerUpdateMs = 0.0f;
            }
            this.updateStartTimeNs = System.nanoTime();
        }
    }

    @Override
    public boolean updateRenderers(bma rg2, sv entityliving, boolean flag) {
        Object wr2;
        int i2;
        this.delayedInit();
        if (rg2.t.size() <= 0) {
            return true;
        }
        int num = 0;
        int NOT_IN_FRUSTRUM_MUL = 4;
        int numValid = 0;
        blo wrBest = null;
        float distSqBest = Float.MAX_VALUE;
        int indexBest = -1;
        for (int i3 = 0; i3 < rg2.t.size(); ++i3) {
            blo wr3 = (blo)rg2.t.get(i3);
            if (wr3 == null) continue;
            ++numValid;
            if (wr3.isUpdating) continue;
            if (!wr3.q) {
                rg2.t.set(i3, null);
                continue;
            }
            float distSq = wr3.a((sa)entityliving);
            if (distSq < 512.0f) {
                if (distSq < 256.0f && rg2.isActingNow() && wr3.l || this.firstUpdate) {
                    if (this.updateThread != null) {
                        this.updateThread.unpauseToEndOfUpdate();
                    }
                    wr3.a(entityliving);
                    wr3.q = false;
                    rg2.t.set(i3, null);
                    ++num;
                    continue;
                }
                if (this.updateThread != null) {
                    this.updateThread.addRendererToUpdate(wr3, true);
                    wr3.q = false;
                    rg2.t.set(i3, null);
                    ++num;
                    continue;
                }
            }
            if (!wr3.l) {
                distSq *= (float)NOT_IN_FRUSTRUM_MUL;
            }
            if (wrBest == null) {
                wrBest = wr3;
                distSqBest = distSq;
                indexBest = i3;
                continue;
            }
            if (!(distSq < distSqBest)) continue;
            wrBest = wr3;
            distSqBest = distSq;
            indexBest = i3;
        }
        int maxUpdateNum = Config.getUpdatesPerFrame();
        boolean turboMode = false;
        if (Config.isDynamicUpdates() && !rg2.isMoving(entityliving)) {
            maxUpdateNum *= 3;
            turboMode = true;
        }
        if (this.updateThread != null && (maxUpdateNum = this.updateThread.getUpdateCapacity()) <= 0) {
            return true;
        }
        if (wrBest != null) {
            this.updateRenderer(wrBest, entityliving);
            rg2.t.set(indexBest, null);
            ++num;
            float maxDiffDistSq = distSqBest / 5.0f;
            for (i2 = 0; i2 < rg2.t.size() && num < maxUpdateNum; ++i2) {
                float diffDistSq;
                wr2 = (blo)rg2.t.get(i2);
                if (wr2 == null || ((blo)wr2).isUpdating) continue;
                float distSq = ((blo)wr2).a((sa)entityliving);
                if (!((blo)wr2).l) {
                    distSq *= (float)NOT_IN_FRUSTRUM_MUL;
                }
                if (!((diffDistSq = Math.abs(distSq - distSqBest)) < maxDiffDistSq)) continue;
                this.updateRenderer((blo)wr2, entityliving);
                rg2.t.set(i2, null);
                ++num;
            }
        }
        if (numValid == 0) {
            rg2.t.clear();
        }
        if (rg2.t.size() > 100 && numValid < rg2.t.size() * 4 / 5) {
            int dstIndex = 0;
            for (int srcIndex = 0; srcIndex < rg2.t.size(); ++srcIndex) {
                wr2 = rg2.t.get(srcIndex);
                if (wr2 == null) continue;
                if (srcIndex != dstIndex) {
                    rg2.t.set(dstIndex, wr2);
                }
                ++dstIndex;
            }
            for (i2 = rg2.t.size() - 1; i2 >= dstIndex; --i2) {
                rg2.t.remove(i2);
            }
        }
        this.firstUpdate = false;
        return true;
    }

    private void updateRenderer(blo wr2, sv entityLiving) {
        WrUpdateThread ut = this.updateThread;
        if (ut != null) {
            ut.addRendererToUpdate(wr2, false);
            wr2.q = false;
            return;
        }
        wr2.a(entityLiving);
        wr2.q = false;
        wr2.isUpdating = false;
    }

    @Override
    public void finishCurrentUpdate() {
        if (this.updateThread != null) {
            this.updateThread.unpauseToEndOfUpdate();
        }
    }

    @Override
    public void resumeBackgroundUpdates() {
        if (this.updateThread != null) {
            this.updateThread.unpause();
        }
    }

    @Override
    public void pauseBackgroundUpdates() {
        if (this.updateThread != null) {
            this.updateThread.pause();
        }
    }

    @Override
    public void clearAllUpdates() {
        if (this.updateThread != null) {
            this.updateThread.clearAllUpdates();
        }
        this.firstUpdate = true;
    }
}

