/*
 * Decompiled with CFR 0.152.
 */
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadersmod.client.ShadersTex;

public class bpz
extends bpp
implements bqk,
rg {
    private static final boolean ENABLE_SKIP = Boolean.parseBoolean(System.getProperty("fml.skipFirstTextureLoad", "true"));
    private static final Logger d = LogManager.getLogger();
    public static final bqx b = new bqx("textures/atlas/blocks.png");
    public static final bqx c = new bqx("textures/atlas/items.png");
    private final List e = Lists.newArrayList();
    private final Map f = Maps.newHashMap();
    private final Map g = Maps.newHashMap();
    public final int h;
    public final String i;
    private int j;
    private int k = 1;
    private final bqd l = new bqd("missingno");
    private static final String __OBFID = "CL_00001058";
    private boolean skipFirst = false;
    public static bpz textureMapBlocks = null;
    public static bpz textureMapItems = null;
    private bqd[] iconGrid = null;
    private int iconGridSize = -1;
    private int iconGridCountX = -1;
    private int iconGridCountY = -1;
    private double iconGridSizeU = -1.0;
    private double iconGridSizeV = -1.0;
    private int counterIndexInMap = 0;
    public int atlasWidth = 0;
    public int atlasHeight = 0;

    public bpz(int par1, String par2Str) {
        this(par1, par2Str, false);
    }

    public bpz(int par1, String par2Str, boolean skipFirst) {
        this.h = par1;
        this.i = par2Str;
        if (this.h == 0) {
            textureMapBlocks = this;
        }
        if (this.h == 1) {
            textureMapItems = this;
        }
        this.g();
        this.skipFirst = skipFirst && ENABLE_SKIP;
    }

    private void f() {
        int[] var1;
        if ((float)this.k > 1.0f) {
            boolean var2 = true;
            boolean var3 = true;
            boolean var4 = true;
            this.l.b(32);
            this.l.c(32);
            var1 = new int[1024];
            System.arraycopy(bqi.b, 0, var1, 0, bqi.b.length);
            bqi.a(var1, 16, 16, 8);
        } else {
            var1 = bqi.b;
            this.l.b(16);
            this.l.c(16);
        }
        int[][] var5 = new int[this.j + 1][];
        var5[0] = var1;
        this.l.a(Lists.newArrayList((Object[])new int[][][]{var5}));
        this.l.setIndexInMap(this.counterIndexInMap++);
    }

    @Override
    public void a(bqy par1ResourceManager) throws IOException {
        ShadersTex.resManager = par1ResourceManager;
        this.counterIndexInMap = 0;
        this.f();
        this.c();
        this.b(par1ResourceManager);
    }

    public void b(bqy par1ResourceManager) {
        ShadersTex.resManager = par1ResourceManager;
        Config.dbg("Loading texture map: " + this.i);
        WrUpdates.finishCurrentUpdate();
        this.g();
        int var2 = TextureUtils.getGLMaximumTextureSize();
        bpv var3 = new bpv(var2, var2, true, 0, this.j);
        this.g.clear();
        this.e.clear();
        int var4 = Integer.MAX_VALUE;
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPre, this);
        Iterator var5 = this.f.entrySet().iterator();
        while (var5.hasNext() && !this.skipFirst) {
            Map.Entry var6 = var5.next();
            bqx var7 = new bqx((String)var6.getKey());
            bqd var8 = (bqd)var6.getValue();
            bqx var9 = this.a(var7, 0);
            if (var8.getIndexInMap() < 0) {
                var8.setIndexInMap(this.counterIndexInMap++);
            }
            if (var8.hasCustomLoader(par1ResourceManager, var7)) {
                if (!var8.load(par1ResourceManager, var7)) {
                    var4 = Math.min(var4, Math.min(var8.a(), var8.b()));
                    var3.a(var8);
                }
                Config.dbg("Custom loader: " + var8);
                continue;
            }
            try {
                bqw var10 = ShadersTex.loadResource(par1ResourceManager, var9);
                BufferedImage[] var11 = new BufferedImage[1 + this.j];
                var11[0] = ImageIO.read(var10.b());
                bsi var12 = (bsi)var10.a("texture");
                if (var12 != null) {
                    int var15;
                    List var13 = var12.c();
                    if (!var13.isEmpty()) {
                        int var14 = var11[0].getWidth();
                        var15 = var11[0].getHeight();
                        if (qh.b(var14) != var14 || qh.b(var15) != var15) {
                            throw new RuntimeException("Unable to load extra miplevels, source-texture is not power of two");
                        }
                    }
                    Iterator var35 = var13.iterator();
                    while (var35.hasNext()) {
                        var15 = (Integer)var35.next();
                        if (var15 <= 0 || var15 >= var11.length - 1 || var11[var15] != null) continue;
                        bqx var16 = this.a(var7, var15);
                        try {
                            var11[var15] = ImageIO.read(ShadersTex.loadResource(par1ResourceManager, var16).b());
                        }
                        catch (IOException var21) {
                            d.error("Unable to load miplevel {} from: {}", new Object[]{var15, var16, var21});
                        }
                    }
                }
                bsa var34 = (bsa)var10.a("animation");
                var8.a(var11, var34, (float)this.k > 1.0f);
            }
            catch (RuntimeException var22) {
                d.error("Unable to parse metadata from " + var9, (Throwable)var22);
                ReflectorForge.FMLClientHandler_trackBrokenTexture(var9, var22.getMessage());
                continue;
            }
            catch (IOException var23) {
                d.error("Using missing texture, unable to load " + var9 + ", " + var23.getClass().getName());
                ReflectorForge.FMLClientHandler_trackMissingTexture(var9);
                continue;
            }
            var4 = Math.min(var4, Math.min(var8.a(), var8.b()));
            var3.a(var8);
        }
        int var24 = qh.c(var4);
        if (var24 < 0) {
            var24 = 0;
        }
        if (var24 < this.j) {
            d.info("{}: dropping miplevel from {} to {}, because of minTexel: {}", new Object[]{this.i, this.j, var24, var4});
            this.j = var24;
        }
        Iterator var25 = this.f.values().iterator();
        while (var25.hasNext() && !this.skipFirst) {
            bqd var27 = (bqd)var25.next();
            try {
                var27.d(this.j);
            }
            catch (Throwable var20) {
                b var29 = b.a(var20, "Applying mipmap");
                k var31 = var29.a("Sprite being mipmapped");
                var31.a("Sprite name", (Callable)new bqa(this, var27));
                var31.a("Sprite size", (Callable)new bqb(this, var27));
                var31.a("Sprite frames", (Callable)new bqc(this, var27));
                var31.a("Mipmap levels", (Object)this.j);
                throw new s(var29);
            }
        }
        this.l.d(this.j);
        var3.a(this.l);
        this.skipFirst = false;
        var3.c();
        Config.dbg("Texture size: " + this.i + ", " + var3.a() + "x" + var3.b());
        int sheetWidth = var3.a();
        int sheetHeight = var3.b();
        BufferedImage debugImage = null;
        if (System.getProperty("saveTextureMap", "false").equalsIgnoreCase("true")) {
            debugImage = this.makeDebugImage(sheetWidth, sheetHeight);
        }
        d.info("Created: {}x{} {}-atlas", new Object[]{var3.a(), var3.b(), this.i});
        if (Config.isShaders()) {
            ShadersTex.allocateTextureMap(this.b(), this.j, var3.a(), var3.b(), var3, this);
        } else {
            bqi.a(this.b(), this.j, var3.a(), var3.b(), (float)this.k);
        }
        HashMap var26 = Maps.newHashMap((Map)this.f);
        for (bqd var8 : var3.d()) {
            if (Config.isShaders()) {
                ShadersTex.setIconName(ShadersTex.setSprite(var8).g());
            }
            String var30 = var8.g();
            var26.remove(var30);
            this.g.put(var30, var8);
            try {
                if (Config.isShaders()) {
                    ShadersTex.uploadTexSubForLoadAtlas(var8.a(0), var8.a(), var8.b(), var8.h(), var8.i(), false, false);
                } else {
                    bqi.a(var8.a(0), var8.a(), var8.b(), var8.h(), var8.i(), false, false);
                }
                if (debugImage != null) {
                    this.addDebugSprite(var8, debugImage);
                }
            }
            catch (Throwable var18) {
                b var32 = b.a(var18, "Stitching texture atlas");
                k var33 = var32.a("Texture being stitched together");
                var33.a("Atlas path", (Object)this.i);
                var33.a("Sprite", (Object)var8);
                throw new s(var32);
            }
            if (var8.m()) {
                this.e.add(var8);
                continue;
            }
            var8.l();
        }
        for (bqd var8 : var26.values()) {
            var8.a(this.l);
        }
        if (debugImage != null) {
            this.writeDebugImage(debugImage, "debug_" + this.i.replace('/', '_') + ".png");
        }
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPost, this);
    }

    public bqx a(bqx p_147634_1_, int p_147634_2_) {
        if (this.isAbsoluteLocation(p_147634_1_)) {
            if (p_147634_2_ == 0) {
                return new bqx(p_147634_1_.b(), p_147634_1_.a() + ".png");
            }
            return new bqx(p_147634_1_.b(), p_147634_1_.a() + "mipmap" + p_147634_2_ + ".png");
        }
        return p_147634_2_ == 0 ? new bqx(p_147634_1_.b(), String.format("%s/%s%s", this.i, p_147634_1_.a(), ".png")) : new bqx(p_147634_1_.b(), String.format("%s/mipmaps/%s.%d%s", this.i, p_147634_1_.a(), p_147634_2_, ".png"));
    }

    private void g() {
        this.f.clear();
        if (this.h == 0) {
            for (aji var2 : aji.c) {
                if (var2.o() == awt.a) continue;
                var2.a((rg)this);
            }
            bao.B().g.a(this);
            bnn.a.a(this);
            ConnectedTextures.updateIcons(this);
        }
        if (this.h == 1) {
            CustomItems.updateIcons(this);
        }
        for (adb var3 : adb.e) {
            if (var3 == null || var3.d() != this.h) continue;
            var3.a((rg)this);
        }
    }

    public bqd b(String par1Str) {
        bqd var2 = (bqd)this.g.get(par1Str);
        if (var2 == null) {
            var2 = this.l;
        }
        return var2;
    }

    public void d() {
        if (Config.isShaders()) {
            ShadersTex.updatingTex = this.getMultiTexID();
        }
        boolean hasNormal = false;
        boolean hasSpecular = false;
        bqi.b(this.b());
        for (bqd var2 : this.e) {
            if (this.h == 0 ? !this.isTerrainAnimationActive(var2) : this.h == 1 && !this.isItemAnimationActive(var2)) continue;
            var2.j();
            if (var2.spriteNormal != null) {
                hasNormal = true;
            }
            if (var2.spriteSpecular == null) continue;
            hasSpecular = true;
        }
        if (Config.isShaders()) {
            if (hasNormal) {
                bqi.b(this.getMultiTexID().norm);
                for (bqd textureatlassprite : this.e) {
                    if (textureatlassprite.spriteNormal == null || !this.isTerrainAnimationActive(textureatlassprite)) continue;
                    if (textureatlassprite == TextureUtils.iconClock || textureatlassprite == TextureUtils.iconCompass) {
                        textureatlassprite.spriteNormal.g = textureatlassprite.g;
                    }
                    textureatlassprite.spriteNormal.j();
                }
            }
            if (hasSpecular) {
                bqi.b(this.getMultiTexID().spec);
                for (bqd textureatlassprite : this.e) {
                    if (textureatlassprite.spriteSpecular == null || !this.isTerrainAnimationActive(textureatlassprite)) continue;
                    if (textureatlassprite == TextureUtils.iconClock || textureatlassprite == TextureUtils.iconCompass) {
                        textureatlassprite.spriteNormal.g = textureatlassprite.g;
                    }
                    textureatlassprite.spriteSpecular.j();
                }
            }
            if (hasNormal || hasSpecular) {
                bqi.b(this.b());
            }
        }
        if (Config.isShaders()) {
            ShadersTex.updatingTex = null;
        }
    }

    private boolean isItemAnimationActive(bqd ts) {
        if (ts == TextureUtils.iconClock || ts == TextureUtils.iconCompass) {
            return true;
        }
        return Config.isAnimatedItems();
    }

    public rf a(String par1Str) {
        if (par1Str == null) {
            throw new IllegalArgumentException("Name cannot be null!");
        }
        if (par1Str.indexOf(92) == -1 || this.isAbsoluteLocationPath(par1Str)) {
            Object var2 = (bqd)this.f.get(par1Str);
            if (var2 == null && this.h == 1 && Reflector.ModLoader_getCustomAnimationLogic.exists()) {
                var2 = Reflector.call(Reflector.ModLoader_getCustomAnimationLogic, par1Str);
            }
            if (var2 == null) {
                bqd tas;
                var2 = this.h == 1 ? ("clock".equals(par1Str) ? new bql(par1Str) : ("compass".equals(par1Str) ? new bqm(par1Str) : new bqd(par1Str))) : new bqd(par1Str);
                this.f.put(par1Str, var2);
                if (var2 instanceof bqd && (tas = (bqd)var2).getIndexInMap() < 0) {
                    tas.setIndexInMap(this.counterIndexInMap++);
                }
            }
            return (rf)var2;
        }
        throw new IllegalArgumentException("Name cannot contain slashes!");
    }

    public int a() {
        return this.h;
    }

    public void e() {
        this.d();
    }

    public void a(int p_147633_1_) {
        this.j = p_147633_1_;
    }

    public void b(int p_147632_1_) {
        this.k = p_147632_1_;
    }

    public bqd getTextureExtry(String name) {
        return (bqd)this.f.get(name);
    }

    public boolean setTextureEntry(String name, bqd entry) {
        if (!this.f.containsKey(name)) {
            this.f.put(name, entry);
            if (entry.getIndexInMap() < 0) {
                entry.setIndexInMap(this.counterIndexInMap++);
            }
            return true;
        }
        return false;
    }

    public boolean setTextureEntry(bqd entry) {
        return this.setTextureEntry(entry.g(), entry);
    }

    public String getBasePath() {
        return this.i;
    }

    public int getMipmapLevels() {
        return this.j;
    }

    private boolean isAbsoluteLocation(bqx loc) {
        String path = loc.a();
        return this.isAbsoluteLocationPath(path);
    }

    private boolean isAbsoluteLocationPath(String resPath) {
        String path = resPath.toLowerCase();
        return path.startsWith("mcpatcher/") || path.startsWith("optifine/");
    }

    public bqd getIconSafe(String name) {
        return (bqd)this.f.get(name);
    }

    private int getStandardTileSize(Collection icons) {
        int[] sizeCounts = new int[16];
        for (bqd tex : icons) {
            int po2h;
            int po2w;
            int po2;
            if (tex == null || (po2 = Math.max(po2w = TextureUtils.getPowerOfTwo(tex.getWidth()), po2h = TextureUtils.getPowerOfTwo(tex.getHeight()))) >= sizeCounts.length) continue;
            int n = po2;
            sizeCounts[n] = sizeCounts[n] + 1;
        }
        int mostUsedPo2 = 4;
        int mostUsedCount = 0;
        for (int i2 = 0; i2 < sizeCounts.length; ++i2) {
            int count = sizeCounts[i2];
            if (count <= mostUsedCount) continue;
            mostUsedPo2 = i2;
            mostUsedCount = count;
        }
        if (mostUsedPo2 < 4) {
            mostUsedPo2 = 4;
        }
        int value = TextureUtils.twoToPower(mostUsedPo2);
        return value;
    }

    private void updateIconGrid(int sheetWidth, int sheetHeight) {
        this.iconGridCountX = -1;
        this.iconGridCountY = -1;
        this.iconGrid = null;
        if (this.iconGridSize <= 0) {
            return;
        }
        this.iconGridCountX = sheetWidth / this.iconGridSize;
        this.iconGridCountY = sheetHeight / this.iconGridSize;
        this.iconGrid = new bqd[this.iconGridCountX * this.iconGridCountY];
        this.iconGridSizeU = 1.0 / (double)this.iconGridCountX;
        this.iconGridSizeV = 1.0 / (double)this.iconGridCountY;
        for (bqd ts : this.g.values()) {
            double deltaU = 0.5 / (double)sheetWidth;
            double deltaV = 0.5 / (double)sheetHeight;
            double uMin = (double)Math.min(ts.c(), ts.d()) + deltaU;
            double vMin = (double)Math.min(ts.e(), ts.f()) + deltaV;
            double uMax = (double)Math.max(ts.c(), ts.d()) - deltaU;
            double vMax = (double)Math.max(ts.e(), ts.f()) - deltaV;
            int iuMin = (int)(uMin / this.iconGridSizeU);
            int ivMin = (int)(vMin / this.iconGridSizeV);
            int iuMax = (int)(uMax / this.iconGridSizeU);
            int ivMax = (int)(vMax / this.iconGridSizeV);
            for (int iu2 = iuMin; iu2 <= iuMax; ++iu2) {
                if (iu2 < 0 || iu2 >= this.iconGridCountX) {
                    Config.warn("Invalid grid U: " + iu2 + ", icon: " + ts.g());
                    continue;
                }
                for (int iv = ivMin; iv <= ivMax; ++iv) {
                    if (iv < 0 || iv >= this.iconGridCountX) {
                        Config.warn("Invalid grid V: " + iv + ", icon: " + ts.g());
                        continue;
                    }
                    int index = iv * this.iconGridCountX + iu2;
                    this.iconGrid[index] = ts;
                }
            }
        }
    }

    public bqd getIconByUV(double u2, double v2) {
        if (this.iconGrid == null) {
            return null;
        }
        int iv = (int)(v2 / this.iconGridSizeV);
        int iu2 = (int)(u2 / this.iconGridSizeU);
        int index = iv * this.iconGridCountX + iu2;
        if (index < 0 || index > this.iconGrid.length) {
            return null;
        }
        return this.iconGrid[index];
    }

    public bqd getMissingSprite() {
        return this.l;
    }

    public int getMaxTextureIndex() {
        return this.f.size();
    }

    private boolean isTerrainAnimationActive(bqd ts) {
        if (ts == TextureUtils.iconWaterStill || ts == TextureUtils.iconWaterFlow) {
            return Config.isAnimatedWater();
        }
        if (ts == TextureUtils.iconLavaStill || ts == TextureUtils.iconLavaFlow) {
            return Config.isAnimatedLava();
        }
        if (ts == TextureUtils.iconFireLayer0 || ts == TextureUtils.iconFireLayer1) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconPortal) {
            return Config.isAnimatedPortal();
        }
        if (ts == TextureUtils.iconClock || ts == TextureUtils.iconCompass) {
            return true;
        }
        return Config.isAnimatedTerrain();
    }

    public int getCountRegisteredSprites() {
        return this.counterIndexInMap;
    }

    public void loadTextureSafe(bqy rm) {
        try {
            this.a(rm);
        }
        catch (IOException e2) {
            Config.warn("Error loading texture map: " + this.i);
            e2.printStackTrace();
        }
    }

    private BufferedImage makeDebugImage(int sheetWidth, int sheetHeight) {
        BufferedImage image = new BufferedImage(sheetWidth, sheetHeight, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setPaint(new Color(255, 255, 0));
        g2.fillRect(0, 0, image.getWidth(), image.getHeight());
        return image;
    }

    private void addDebugSprite(bqd ts, BufferedImage image) {
        if (ts.k() < 1) {
            Config.warn("Debug sprite has no data: " + ts.g());
            return;
        }
        int[] data = ts.a(0)[0];
        image.setRGB(ts.h(), ts.i(), ts.a(), ts.b(), data, 0, ts.a());
    }

    private void writeDebugImage(BufferedImage image, String pngPath) {
        try {
            ImageIO.write((RenderedImage)image, "png", new File(Config.getMinecraft().w, pngPath));
        }
        catch (Exception var9) {
            var9.printStackTrace();
        }
    }
}

