/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import java.util.ArrayList;
import java.util.HashSet;

public class BlockAlias {
    private int blockId;
    private MatchBlock[] matchBlocks;

    public BlockAlias(int blockId, MatchBlock[] matchBlocks) {
        this.blockId = blockId;
        this.matchBlocks = matchBlocks;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public boolean matches(int id, int metadata) {
        for (int i2 = 0; i2 < this.matchBlocks.length; ++i2) {
            MatchBlock matchBlock = this.matchBlocks[i2];
            if (!matchBlock.matches(id, metadata)) continue;
            return true;
        }
        return false;
    }

    public int[] getMatchBlockIds() {
        HashSet<Integer> blockIdSet = new HashSet<Integer>();
        for (int i2 = 0; i2 < this.matchBlocks.length; ++i2) {
            MatchBlock matchBlock = this.matchBlocks[i2];
            int blockId = matchBlock.getBlockId();
            blockIdSet.add(blockId);
        }
        Integer[] blockIdsArr = blockIdSet.toArray(new Integer[blockIdSet.size()]);
        int[] blockIds = Config.toPrimitive(blockIdsArr);
        return blockIds;
    }

    public MatchBlock[] getMatchBlocks(int matchBlockId) {
        ArrayList<MatchBlock> listMatchBlock = new ArrayList<MatchBlock>();
        for (int i2 = 0; i2 < this.matchBlocks.length; ++i2) {
            MatchBlock mb = this.matchBlocks[i2];
            if (mb.getBlockId() != matchBlockId) continue;
            listMatchBlock.add(mb);
        }
        MatchBlock[] mbs = listMatchBlock.toArray(new MatchBlock[listMatchBlock.size()]);
        return mbs;
    }

    public String toString() {
        return "block." + this.blockId + "=" + Config.arrayToString(this.matchBlocks);
    }
}

