/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import shadersmod.client.GuiButtonShaderOption;
import shadersmod.client.GuiSliderShaderOption;
import shadersmod.client.ShaderOption;
import shadersmod.client.ShaderOptionProfile;
import shadersmod.client.ShaderOptionScreen;
import shadersmod.client.Shaders;

public class GuiShaderOptions
extends GuiScreenOF {
    private bdw prevScreen;
    protected String title = "Shader Options";
    private bbj settings;
    private TooltipManager tooltipManager = new TooltipManager(this, new TooltipProviderShaderOptions());
    private String screenName = null;
    private String screenText = null;
    private boolean changed = false;
    public static final String OPTION_PROFILE = "<profile>";
    public static final String OPTION_EMPTY = "<empty>";
    public static final String OPTION_REST = "*";
    private bbu fontRendererObj;

    public GuiShaderOptions(bdw guiscreen, bbj gamesettings) {
        this.prevScreen = guiscreen;
        this.settings = gamesettings;
    }

    public GuiShaderOptions(bdw guiscreen, bbj gamesettings, String screenName) {
        this(guiscreen, gamesettings);
        this.screenName = screenName;
        if (screenName != null) {
            this.screenText = Shaders.translate("screen." + screenName, screenName);
        }
    }

    public void b() {
        this.fontRendererObj = this.q;
        this.title = brp.a("of.options.shaderOptionsTitle", new Object[0]);
        int baseId = 100;
        int baseX = 0;
        int baseY = 30;
        int stepY = 20;
        int btnWidth = 120;
        int btnHeight = 20;
        int columns = Shaders.getShaderPackColumns(this.screenName, 2);
        ShaderOption[] ops = Shaders.getShaderPackOptions(this.screenName);
        if (ops != null) {
            int colsMin = qh.f((double)ops.length / 9.0);
            if (columns < colsMin) {
                columns = colsMin;
            }
            for (int i2 = 0; i2 < ops.length; ++i2) {
                ShaderOption so = ops[i2];
                if (so == null || !so.isVisible()) continue;
                int col = i2 % columns;
                int row = i2 / columns;
                int colWidth = Math.min(this.l / columns, 200);
                baseX = (this.l - colWidth * columns) / 2;
                int x = col * colWidth + 5 + baseX;
                int y = baseY + row * stepY;
                int w2 = colWidth - 10;
                int h2 = btnHeight;
                String text = GuiShaderOptions.getButtonText(so, w2);
                GuiButtonShaderOption btn = Shaders.isShaderPackOptionSlider(so.getName()) ? new GuiSliderShaderOption(baseId + i2, x, y, w2, h2, so, text) : new GuiButtonShaderOption(baseId + i2, x, y, w2, h2, so, text);
                btn.l = so.isEnabled();
                this.n.add(btn);
            }
        }
        this.n.add(new bcb(201, this.l / 2 - btnWidth - 20, this.m / 6 + 168 + 11, btnWidth, btnHeight, brp.a("controls.reset", new Object[0])));
        this.n.add(new bcb(200, this.l / 2 + 20, this.m / 6 + 168 + 11, btnWidth, btnHeight, brp.a("gui.done", new Object[0])));
    }

    public static String getButtonText(ShaderOption so, int btnWidth) {
        String labelName = so.getNameText();
        if (so instanceof ShaderOptionScreen) {
            ShaderOptionScreen soScr = (ShaderOptionScreen)so;
            return labelName + "...";
        }
        bbu fr = Config.getMinecraft().l;
        int lenSuffix = fr.a(": " + Lang.getOff()) + 5;
        while (fr.a(labelName) + lenSuffix >= btnWidth && labelName.length() > 0) {
            labelName = labelName.substring(0, labelName.length() - 1);
        }
        String col = so.isChanged() ? so.getValueColor(so.getValue()) : "";
        String labelValue = so.getValueText(so.getValue());
        return labelName + ": " + col + labelValue;
    }

    protected void a(bcb guibutton) {
        if (!guibutton.l) {
            return;
        }
        if (guibutton.k < 200 && guibutton instanceof GuiButtonShaderOption) {
            GuiButtonShaderOption btnSo = (GuiButtonShaderOption)guibutton;
            ShaderOption so = btnSo.getShaderOption();
            if (so instanceof ShaderOptionScreen) {
                String screenName = so.getName();
                GuiShaderOptions scr = new GuiShaderOptions(this, this.settings, screenName);
                this.k.a((bdw)scr);
                return;
            }
            if (GuiShaderOptions.r()) {
                so.resetValue();
            } else {
                so.nextValue();
            }
            this.updateAllButtons();
            this.changed = true;
        }
        if (guibutton.k == 201) {
            ShaderOption[] opts = Shaders.getChangedOptions(Shaders.getShaderPackOptions());
            for (int i2 = 0; i2 < opts.length; ++i2) {
                ShaderOption opt = opts[i2];
                opt.resetValue();
                this.changed = true;
            }
            this.updateAllButtons();
        }
        if (guibutton.k == 200) {
            if (this.changed) {
                Shaders.saveShaderPackOptions();
                this.changed = false;
                Shaders.uninit();
            }
            this.k.a(this.prevScreen);
        }
    }

    @Override
    protected void actionPerformedRightClick(bcb btn) {
        if (btn instanceof GuiButtonShaderOption) {
            GuiButtonShaderOption btnSo = (GuiButtonShaderOption)btn;
            ShaderOption so = btnSo.getShaderOption();
            if (GuiShaderOptions.r()) {
                so.resetValue();
            } else {
                so.prevValue();
            }
            this.updateAllButtons();
            this.changed = true;
        }
    }

    public void m() {
        super.m();
        if (this.changed) {
            Shaders.saveShaderPackOptions();
            this.changed = false;
            Shaders.uninit();
        }
    }

    private void updateAllButtons() {
        for (bcb btn : this.n) {
            if (!(btn instanceof GuiButtonShaderOption)) continue;
            GuiButtonShaderOption gbso = (GuiButtonShaderOption)btn;
            ShaderOption opt = gbso.getShaderOption();
            if (opt instanceof ShaderOptionProfile) {
                ShaderOptionProfile optProf = (ShaderOptionProfile)opt;
                optProf.updateProfile();
            }
            gbso.j = GuiShaderOptions.getButtonText(opt, gbso.b());
            gbso.valueChanged();
        }
    }

    public void a(int x, int y, float f2) {
        this.c();
        if (this.screenText != null) {
            this.a(this.fontRendererObj, this.screenText, this.l / 2, 15, 0xFFFFFF);
        } else {
            this.a(this.fontRendererObj, this.title, this.l / 2, 15, 0xFFFFFF);
        }
        super.a(x, y, f2);
        this.tooltipManager.drawTooltips(x, y, this.n);
    }
}

