/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.optifine.entity.model.anim.ExpressionParser;
import net.optifine.entity.model.anim.ExpressionType;
import net.optifine.entity.model.anim.IExpression;
import net.optifine.entity.model.anim.ParseException;
import shadersmod.client.IShaderPack;
import shadersmod.client.ScreenShaderOptions;
import shadersmod.client.ShaderMacros;
import shadersmod.client.ShaderOption;
import shadersmod.client.ShaderOptionProfile;
import shadersmod.client.ShaderOptionRest;
import shadersmod.client.ShaderOptionScreen;
import shadersmod.client.ShaderOptionSwitch;
import shadersmod.client.ShaderOptionSwitchConst;
import shadersmod.client.ShaderOptionVariable;
import shadersmod.client.ShaderOptionVariableConst;
import shadersmod.client.ShaderProfile;
import shadersmod.client.ShaderUtils;
import shadersmod.client.Shaders;
import shadersmod.common.SMCLog;
import shadersmod.uniform.CustomUniform;
import shadersmod.uniform.CustomUniforms;
import shadersmod.uniform.ShaderExpressionResolver;
import shadersmod.uniform.UniformType;

public class ShaderPackParser {
    private static final Pattern PATTERN_VERSION = Pattern.compile("^\\s*#version\\s+.*$");
    private static final Pattern PATTERN_INCLUDE = Pattern.compile("^\\s*#include\\s+\"([A-Za-z0-9_/\\.]+)\".*$");
    private static final Set<String> setConstNames = ShaderPackParser.makeSetConstNames();

    public static ShaderOption[] parseShaderPackOptions(IShaderPack shaderPack, String[] programNames, List<Integer> listDimensions) {
        if (shaderPack == null) {
            return new ShaderOption[0];
        }
        HashMap<String, ShaderOption> mapOptions = new HashMap<String, ShaderOption>();
        ShaderPackParser.collectShaderOptions(shaderPack, "/shaders", programNames, mapOptions);
        for (int dimId : listDimensions) {
            String dirWorld = "/shaders/world" + dimId;
            ShaderPackParser.collectShaderOptions(shaderPack, dirWorld, programNames, mapOptions);
        }
        Collection options = mapOptions.values();
        ShaderOption[] sos = options.toArray(new ShaderOption[options.size()]);
        Comparator<ShaderOption> comp = new Comparator<ShaderOption>(){

            @Override
            public int compare(ShaderOption o1, ShaderOption o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        Arrays.sort(sos, comp);
        return sos;
    }

    private static void collectShaderOptions(IShaderPack shaderPack, String dir, String[] programNames, Map<String, ShaderOption> mapOptions) {
        for (int i2 = 0; i2 < programNames.length; ++i2) {
            String programName = programNames[i2];
            if (programName.equals("")) continue;
            String vsh = dir + "/" + programName + ".vsh";
            String fsh = dir + "/" + programName + ".fsh";
            ShaderPackParser.collectShaderOptions(shaderPack, vsh, mapOptions);
            ShaderPackParser.collectShaderOptions(shaderPack, fsh, mapOptions);
        }
    }

    private static void collectShaderOptions(IShaderPack sp, String path, Map<String, ShaderOption> mapOptions) {
        String[] lines = ShaderPackParser.getLines(sp, path);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            ShaderOption so = ShaderPackParser.getShaderOption(line, path);
            if (so == null || so.getName().startsWith(ShaderMacros.getPrefixMacro()) || so.checkUsed() && !ShaderPackParser.isOptionUsed(so, lines)) continue;
            String key = so.getName();
            ShaderOption so2 = mapOptions.get(key);
            if (so2 != null) {
                if (!Config.equals(so2.getValueDefault(), so.getValueDefault())) {
                    Config.warn("Ambiguous shader option: " + so.getName());
                    Config.warn(" - in " + Config.arrayToString(so2.getPaths()) + ": " + so2.getValueDefault());
                    Config.warn(" - in " + Config.arrayToString(so.getPaths()) + ": " + so.getValueDefault());
                    so2.setEnabled(false);
                }
                if (so2.getDescription() == null || so2.getDescription().length() <= 0) {
                    so2.setDescription(so.getDescription());
                }
                so2.addPaths(so.getPaths());
                continue;
            }
            mapOptions.put(key, so);
        }
    }

    private static boolean isOptionUsed(ShaderOption so, String[] lines) {
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            if (!so.isUsedInLine(line)) continue;
            return true;
        }
        return false;
    }

    private static String[] getLines(IShaderPack sp, String path) {
        try {
            ArrayList<String> listFiles = new ArrayList<String>();
            String str = ShaderPackParser.loadFile(path, sp, 0, listFiles, 0);
            if (str == null) {
                return new String[0];
            }
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
            String[] lines = Config.readLines(is);
            return lines;
        }
        catch (IOException e2) {
            Config.dbg(e2.getClass().getName() + ": " + e2.getMessage());
            return new String[0];
        }
    }

    private static ShaderOption getShaderOption(String line, String path) {
        ShaderOption so = null;
        if (so == null) {
            so = ShaderOptionSwitch.parseOption(line, path);
        }
        if (so == null) {
            so = ShaderOptionVariable.parseOption(line, path);
        }
        if (so != null) {
            return so;
        }
        if (so == null) {
            so = ShaderOptionSwitchConst.parseOption(line, path);
        }
        if (so == null) {
            so = ShaderOptionVariableConst.parseOption(line, path);
        }
        if (so != null && setConstNames.contains(so.getName())) {
            return so;
        }
        return null;
    }

    private static Set<String> makeSetConstNames() {
        HashSet<String> set = new HashSet<String>();
        set.add("shadowMapResolution");
        set.add("shadowMapFov");
        set.add("shadowDistance");
        set.add("shadowDistanceRenderMul");
        set.add("shadowIntervalSize");
        set.add("generateShadowMipmap");
        set.add("generateShadowColorMipmap");
        set.add("shadowHardwareFiltering");
        set.add("shadowHardwareFiltering0");
        set.add("shadowHardwareFiltering1");
        set.add("shadowtex0Mipmap");
        set.add("shadowtexMipmap");
        set.add("shadowtex1Mipmap");
        set.add("shadowcolor0Mipmap");
        set.add("shadowColor0Mipmap");
        set.add("shadowcolor1Mipmap");
        set.add("shadowColor1Mipmap");
        set.add("shadowtex0Nearest");
        set.add("shadowtexNearest");
        set.add("shadow0MinMagNearest");
        set.add("shadowtex1Nearest");
        set.add("shadow1MinMagNearest");
        set.add("shadowcolor0Nearest");
        set.add("shadowColor0Nearest");
        set.add("shadowColor0MinMagNearest");
        set.add("shadowcolor1Nearest");
        set.add("shadowColor1Nearest");
        set.add("shadowColor1MinMagNearest");
        set.add("wetnessHalflife");
        set.add("drynessHalflife");
        set.add("eyeBrightnessHalflife");
        set.add("centerDepthHalflife");
        set.add("sunPathRotation");
        set.add("ambientOcclusionLevel");
        set.add("superSamplingLevel");
        set.add("noiseTextureResolution");
        return set;
    }

    public static ShaderProfile[] parseProfiles(Properties props, ShaderOption[] shaderOptions) {
        String PREFIX_PROFILE = "profile.";
        ArrayList<ShaderProfile> list = new ArrayList<ShaderProfile>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(PREFIX_PROFILE)) continue;
            String name = string.substring(PREFIX_PROFILE.length());
            String val = props.getProperty(string);
            HashSet<String> parsedProfiles = new HashSet<String>();
            ShaderProfile p2 = ShaderPackParser.parseProfile(name, props, parsedProfiles, shaderOptions);
            if (p2 == null) continue;
            list.add(p2);
        }
        if (list.size() <= 0) {
            return null;
        }
        ShaderProfile[] profs = list.toArray(new ShaderProfile[list.size()]);
        return profs;
    }

    public static Set<String> parseOptionSliders(Properties props, ShaderOption[] shaderOptions) {
        HashSet<String> sliders = new HashSet<String>();
        String value = props.getProperty("sliders");
        if (value == null) {
            return sliders;
        }
        String[] names = Config.tokenize(value, " ");
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            ShaderOption so = ShaderUtils.getShaderOption(name, shaderOptions);
            if (so == null) {
                Config.warn("Invalid shader option: " + name);
                continue;
            }
            sliders.add(name);
        }
        return sliders;
    }

    private static ShaderProfile parseProfile(String name, Properties props, Set<String> parsedProfiles, ShaderOption[] shaderOptions) {
        String PREFIX_PROFILE = "profile.";
        String key = PREFIX_PROFILE + name;
        if (parsedProfiles.contains(key)) {
            Config.warn("[Shaders] Profile already parsed: " + name);
            return null;
        }
        parsedProfiles.add(name);
        ShaderProfile prof = new ShaderProfile(name);
        String val = props.getProperty(key);
        String[] parts = Config.tokenize(val, " ");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String option;
            String part = parts[i2];
            if (part.startsWith(PREFIX_PROFILE)) {
                String nameParent = part.substring(PREFIX_PROFILE.length());
                ShaderProfile profParent = ShaderPackParser.parseProfile(nameParent, props, parsedProfiles, shaderOptions);
                if (prof == null) continue;
                prof.addOptionValues(profParent);
                prof.addDisabledPrograms(profParent.getDisabledPrograms());
                continue;
            }
            String[] tokens = Config.tokenize(part, ":=");
            if (tokens.length == 1) {
                String PREFIX_PROGRAM;
                option = tokens[0];
                boolean on = true;
                if (option.startsWith("!")) {
                    on = false;
                    option = option.substring(1);
                }
                if (option.startsWith(PREFIX_PROGRAM = "program.")) {
                    String program = option.substring(PREFIX_PROGRAM.length());
                    if (!Shaders.isProgramPath(program)) {
                        Config.warn("Invalid program: " + program + " in profile: " + prof.getName());
                        continue;
                    }
                    if (on) {
                        prof.removeDisabledProgram(program);
                        continue;
                    }
                    prof.addDisabledProgram(program);
                    continue;
                }
                ShaderOption so = ShaderUtils.getShaderOption(option, shaderOptions);
                if (!(so instanceof ShaderOptionSwitch)) {
                    Config.warn("[Shaders] Invalid option: " + option);
                    continue;
                }
                prof.addOptionValue(option, String.valueOf(on));
                so.setVisible(true);
                continue;
            }
            if (tokens.length != 2) {
                Config.warn("[Shaders] Invalid option value: " + part);
                continue;
            }
            option = tokens[0];
            String value = tokens[1];
            ShaderOption so = ShaderUtils.getShaderOption(option, shaderOptions);
            if (so == null) {
                Config.warn("[Shaders] Invalid option: " + part);
                continue;
            }
            if (!so.isValidValue(value)) {
                Config.warn("[Shaders] Invalid value: " + part);
                continue;
            }
            so.setVisible(true);
            prof.addOptionValue(option, value);
        }
        return prof;
    }

    public static Map<String, ScreenShaderOptions> parseGuiScreens(Properties props, ShaderProfile[] shaderProfiles, ShaderOption[] shaderOptions) {
        HashMap<String, ScreenShaderOptions> map = new HashMap<String, ScreenShaderOptions>();
        ShaderPackParser.parseGuiScreen("screen", props, map, shaderProfiles, shaderOptions);
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    private static boolean parseGuiScreen(String key, Properties props, Map<String, ScreenShaderOptions> map, ShaderProfile[] shaderProfiles, ShaderOption[] shaderOptions) {
        String val = props.getProperty(key);
        if (val == null) {
            return false;
        }
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        HashSet<String> setNames = new HashSet<String>();
        String[] opNames = Config.tokenize(val, " ");
        for (int i2 = 0; i2 < opNames.length; ++i2) {
            String opName = opNames[i2];
            if (opName.equals("<empty>")) {
                list.add(null);
                continue;
            }
            if (setNames.contains(opName)) {
                Config.warn("[Shaders] Duplicate option: " + opName + ", key: " + key);
                continue;
            }
            setNames.add(opName);
            if (opName.equals("<profile>")) {
                if (shaderProfiles == null) {
                    Config.warn("[Shaders] Option profile can not be used, no profiles defined: " + opName + ", key: " + key);
                    continue;
                }
                ShaderOptionProfile optionProfile = new ShaderOptionProfile(shaderProfiles, shaderOptions);
                list.add(optionProfile);
                continue;
            }
            if (opName.equals("*")) {
                ShaderOptionRest soRest = new ShaderOptionRest("<rest>");
                list.add(soRest);
                continue;
            }
            if (opName.startsWith("[") && opName.endsWith("]")) {
                String screen = StrUtils.removePrefixSuffix(opName, "[", "]");
                if (!screen.matches("^[a-zA-Z0-9_]+$")) {
                    Config.warn("[Shaders] Invalid screen: " + opName + ", key: " + key);
                    continue;
                }
                if (!ShaderPackParser.parseGuiScreen("screen." + screen, props, map, shaderProfiles, shaderOptions)) {
                    Config.warn("[Shaders] Invalid screen: " + opName + ", key: " + key);
                    continue;
                }
                ShaderOptionScreen optionScreen = new ShaderOptionScreen(screen);
                list.add(optionScreen);
                continue;
            }
            ShaderOption so = ShaderUtils.getShaderOption(opName, shaderOptions);
            if (so == null) {
                Config.warn("[Shaders] Invalid option: " + opName + ", key: " + key);
                list.add(null);
                continue;
            }
            so.setVisible(true);
            list.add(so);
        }
        ShaderOption[] scrOps = list.toArray(new ShaderOption[list.size()]);
        String colStr = props.getProperty(key + ".columns");
        int columns = Config.parseInt(colStr, 2);
        ScreenShaderOptions sso = new ScreenShaderOptions(key, scrOps, columns);
        map.put(key, sso);
        return true;
    }

    public static BufferedReader resolveIncludes(BufferedReader reader, String filePath, IShaderPack shaderPack, int fileIndex, List<String> listFiles, int includeLevel) throws IOException {
        String line;
        String fileDir = "/";
        int pos = filePath.lastIndexOf("/");
        if (pos >= 0) {
            fileDir = filePath.substring(0, pos);
        }
        CharArrayWriter caw = new CharArrayWriter();
        int macroInsertPosition = -1;
        LinkedHashSet<String> setExtensions = new LinkedHashSet<String>();
        int lineNumber = 1;
        while ((line = reader.readLine()) != null) {
            Matcher mi;
            Matcher mv;
            if (macroInsertPosition < 0 && (mv = PATTERN_VERSION.matcher(line)).matches()) {
                String strDef = ShaderMacros.getMacroLines();
                String lineA = line + "\n" + strDef;
                String lineB = "#line " + (lineNumber + 1) + " " + fileIndex;
                line = lineA + lineB;
                macroInsertPosition = caw.size() + lineA.length();
            }
            if ((mi = PATTERN_INCLUDE.matcher(line)).matches()) {
                int includeFileIndex;
                String filePathInc;
                String fileInc = mi.group(1);
                boolean absolute = fileInc.startsWith("/");
                String string = filePathInc = absolute ? "/shaders" + fileInc : fileDir + "/" + fileInc;
                if (!listFiles.contains(filePathInc)) {
                    listFiles.add(filePathInc);
                }
                if ((line = ShaderPackParser.loadFile(filePathInc, shaderPack, includeFileIndex = listFiles.indexOf(filePathInc) + 1, listFiles, includeLevel)) == null) {
                    throw new IOException("Included file not found: " + filePath);
                }
                if (line.endsWith("\n")) {
                    line = line.substring(0, line.length() - 1);
                }
                line = "#line 1 " + includeFileIndex + "\n" + line + "\n" + "#line " + (lineNumber + 1) + " " + fileIndex;
            }
            if (macroInsertPosition >= 0 && line.contains(ShaderMacros.getPrefixMacro())) {
                String[] lineExts = ShaderPackParser.findExtensions(line, ShaderMacros.getExtensions());
                for (int i2 = 0; i2 < lineExts.length; ++i2) {
                    String ext = lineExts[i2];
                    setExtensions.add(ext);
                }
            }
            caw.write(line);
            caw.write("\n");
            ++lineNumber;
        }
        char[] chars = caw.toCharArray();
        if (macroInsertPosition >= 0 && setExtensions.size() > 0) {
            StringBuilder sbExt = new StringBuilder();
            for (String ext : setExtensions) {
                sbExt.append("#define ");
                sbExt.append(ext);
                sbExt.append("\n");
            }
            String strExt = sbExt.toString();
            StringBuilder sbAll = new StringBuilder(new String(chars));
            sbAll.insert(macroInsertPosition, strExt);
            String strAll = sbAll.toString();
            chars = strAll.toCharArray();
        }
        CharArrayReader car = new CharArrayReader(chars);
        return new BufferedReader(car);
    }

    private static String[] findExtensions(String line, String[] extensions) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            String ext = extensions[i2];
            if (!line.contains(ext)) continue;
            list.add(ext);
        }
        String[] exts = list.toArray(new String[list.size()]);
        return exts;
    }

    private static String loadFile(String filePath, IShaderPack shaderPack, int fileIndex, List<String> listFiles, int includeLevel) throws IOException {
        String line;
        if (includeLevel >= 10) {
            throw new IOException("#include depth exceeded: " + includeLevel + ", file: " + filePath);
        }
        ++includeLevel;
        InputStream in = shaderPack.getResourceAsStream(filePath);
        if (in == null) {
            return null;
        }
        InputStreamReader isr = new InputStreamReader(in, "ASCII");
        BufferedReader br = new BufferedReader(isr);
        br = ShaderPackParser.resolveIncludes(br, filePath, shaderPack, fileIndex, listFiles, includeLevel);
        CharArrayWriter caw = new CharArrayWriter();
        while ((line = br.readLine()) != null) {
            caw.write(line);
            caw.write("\n");
        }
        return caw.toString();
    }

    public static CustomUniforms parseCustomUniforms(Properties props) {
        String UNIFORM = "uniform";
        String VARIABLE = "variable";
        String PREFIX_UNIFORM = UNIFORM + ".";
        String PREFIX_VARIABLE = VARIABLE + ".";
        HashMap<String, IExpression> mapExpressions = new HashMap<String, IExpression>();
        ArrayList<CustomUniform> listUniforms = new ArrayList<CustomUniform>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String[] keyParts = Config.tokenize(string, ".");
            if (keyParts.length != 3) continue;
            String kind = keyParts[0];
            String type = keyParts[1];
            String name = keyParts[2];
            String src = props.getProperty(string).trim();
            if (mapExpressions.containsKey(name)) {
                SMCLog.warning("Expression already defined: " + name);
                continue;
            }
            if (!kind.equals(UNIFORM) && !kind.equals(VARIABLE)) continue;
            SMCLog.info("Custom " + kind + ": " + name);
            CustomUniform cu = ShaderPackParser.parseCustomUniform(kind, name, type, src, mapExpressions);
            if (cu == null) continue;
            mapExpressions.put(name, cu.getExpression());
            if (kind.equals(VARIABLE)) continue;
            listUniforms.add(cu);
        }
        if (listUniforms.size() <= 0) {
            return null;
        }
        CustomUniform[] cusArr = listUniforms.toArray(new CustomUniform[listUniforms.size()]);
        CustomUniforms customUniforms = new CustomUniforms(cusArr);
        return customUniforms;
    }

    private static CustomUniform parseCustomUniform(String kind, String name, String type, String src, Map<String, IExpression> mapExpressions) {
        try {
            UniformType uniformType = UniformType.parse(type);
            if (uniformType == null) {
                SMCLog.warning("Unknown " + kind + " type: " + (Object)((Object)uniformType));
                return null;
            }
            ShaderExpressionResolver resolver = new ShaderExpressionResolver(mapExpressions);
            ExpressionParser parser = new ExpressionParser(resolver);
            IExpression expr = parser.parse(src);
            ExpressionType expressionType = expr.getExpressionType();
            if (!uniformType.matchesExpressionType(expressionType)) {
                SMCLog.warning("Expression type does not match " + kind + " type, expression: " + (Object)((Object)expressionType) + ", " + kind + ": " + (Object)((Object)uniformType) + " " + name);
                return null;
            }
            CustomUniform cu = new CustomUniform(name, uniformType, expr);
            return cu;
        }
        catch (ParseException e2) {
            SMCLog.warning(e2.getClass().getName() + ": " + e2.getMessage());
            return null;
        }
    }
}

