/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.plyushkinlog.client;

import by.fxg.plyushkinlog.PlyushkinLog;
import by.fxg.plyushkinlog.client.ClientProxy;
import by.fxg.plyushkinlog.client.ClipboardFiles;
import by.fxg.plyushkinlog.client.DebugOverlayRenderer;
import by.fxg.plyushkinlog.client.standard.gl.GLDebugInfo;
import by.fxg.plyushkinlog.standard.InfoSection;
import by.fxg.plyushkinlog.standard.mc.CraftDebugInfo;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class ClientEventHandler {
    private DebugOverlayRenderer debugRenderer;
    private boolean showDebugOverlay = false;

    public void initDebugRenderer() {
        this.debugRenderer = new DebugOverlayRenderer();
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (ClientProxy.keyShowDebugOverlay.func_151468_f()) {
            boolean bl = this.showDebugOverlay = !this.showDebugOverlay;
            if (this.showDebugOverlay) {
                this.debugRenderer.DEBUG_ACTIVATE();
            }
        }
        if (ClientProxy.keySnapDebugInfo.func_151468_f()) {
            this.snapDebugInfo();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.showDebugOverlay) {
            this.debugRenderer.update();
        }
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent.Post event) {
        if (this.showDebugOverlay && event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            this.debugRenderer.render(event.resolution.func_78326_a(), event.resolution.func_78328_b(), event.resolution.func_78325_e());
        }
    }

    private void snapDebugInfo() {
        try {
            InfoSection snap = new InfoSection("PlyushkinSnap");
            snap.addInfo(new CraftDebugInfo());
            snap.addInfo(new GLDebugInfo());
            File file = new File(System.getProperty("java.io.tmpdir") + "\\plyushkin" + System.currentTimeMillis() / 1000L + ".log");
            if (file.exists()) {
                file.createNewFile();
            }
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file, false));
            snap.flushData(writer, "| ", "");
            writer.close();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ClipboardFiles(file), null);
            PlyushkinLog.LOGGER.info("Log saved to " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            PlyushkinLog.LOGGER.error("Unable to snap debug info");
            exception.printStackTrace();
        }
    }
}

