/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.plyushkinlog.client;

public class RefreshableValue {
    protected static final String[] ANIMATION = new String[]{"[/] ", "[-] ", "[\\] ", "[_] "};
    protected static final String UPDATED = "[V] ";
    protected static final String DELIMITER = ": ";
    protected final String name;
    protected final int ticksToRefresh;
    protected final Refresher refresher;
    protected int refreshTimer;
    protected int value;
    protected String outputString;

    public RefreshableValue(String name, int ticksToRefresh, Refresher refresher) {
        this.name = name;
        this.ticksToRefresh = ticksToRefresh - 1;
        this.refresher = refresher;
        this.value = this.refresher.refresh();
        StringBuilder builder = new StringBuilder(ANIMATION[1]);
        this.outputString = builder.append(this.name).append(DELIMITER).append(this.value).toString();
    }

    public void update() {
        if (++this.refreshTimer > this.ticksToRefresh) {
            this.value = this.refresher.refresh();
            this.refreshTimer = 0;
        }
        if ((this.refreshTimer - 5) % 2 == 0) {
            StringBuilder builder = new StringBuilder(this.refreshTimer < 5 ? UPDATED : ANIMATION[(this.refreshTimer - 5) % 8 / 2]);
            this.outputString = builder.append(this.name).append(DELIMITER).append(this.value).toString();
        }
    }

    public String getString() {
        return this.outputString;
    }

    @FunctionalInterface
    public static interface Refresher {
        public int refresh();
    }
}

