/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.plyushkinlog.client.standard.gl;

import by.fxg.plyushkinlog.standard.InfoSection;
import by.fxg.plyushkinlog.standard.UnitInfo;
import by.fxg.plyushkinlog.structure.IStorableInfo;
import java.io.IOException;
import java.util.regex.Pattern;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public final class GLPlatformInfo
extends InfoSection {
    private final String[] extensions;

    public GLPlatformInfo(String name) {
        super(name);
        this.addInfo(new UnitInfo("Vendor", GL11.glGetString((int)7936)));
        this.addInfo(new UnitInfo("Renderer", GL11.glGetString((int)7937)));
        this.addInfo(new UnitInfo("GL Version", GL11.glGetString((int)7938)));
        this.addInfo(new UnitInfo("GLSL Version", GL11.glGetString((int)35724)));
        this.addInfo(new UnitInfo("Display Version", Display.getVersion()));
        String[] extensionArray = GL11.glGetString((int)7939).split(Pattern.quote(" "));
        this.extensions = new String[extensionArray.length / 10 + (extensionArray.length % 10 == 0 ? 0 : 1)];
        for (int i = 0; i != this.extensions.length; ++i) {
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j != 10 && i * 10 + j < extensionArray.length; ++j) {
                builder.append(extensionArray[i * 10 + j]).append(" ");
            }
            builder.setLength(builder.length() - 1);
            this.extensions[i] = builder.toString();
        }
    }

    @Override
    public String getTypeName() {
        return "[GL Platform]";
    }

    @Override
    public void flushData(Appendable out, String prefix, String depthPrefix) throws IOException {
        this.write(out, depthPrefix, this.getTypeName(), " ", this.getEntryName(), " {");
        String nextDepthPrefix = this.format(depthPrefix, prefix);
        for (IStorableInfo info : this.infoList) {
            info.flushData(out, prefix, nextDepthPrefix);
        }
        this.write(out, nextDepthPrefix, "[GL EXTENSIONS] {");
        String extensionsDepthPrefix = this.format(nextDepthPrefix, depthPrefix);
        for (String line : this.extensions) {
            this.write(out, extensionsDepthPrefix, line);
        }
        this.write(out, nextDepthPrefix, "} (GL EXTENSIONS)");
        this.write(out, depthPrefix, "} (", this.getEntryName(), ")");
    }
}

