/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.plyushkinlog.client.standard.gl;

import by.fxg.plyushkinlog.client.ClientProxy;
import by.fxg.plyushkinlog.client.RefreshableValue;
import by.fxg.plyushkinlog.structure.MemoryUnit;
import java.nio.IntBuffer;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public final class MemoryRefreshableValues
extends RefreshableValue {
    private String[] descriptions;
    private String[] memoryValues;
    private String[] output;
    private int memType = 0;

    public MemoryRefreshableValues(int ticksToRefresh) {
        super(null, ticksToRefresh, () -> 0);
        int dataSize;
        ContextCapabilities caps = GLContext.getCapabilities();
        int n = caps.GL_NVX_gpu_memory_info ? 5 : (dataSize = caps.GL_ATI_meminfo ? 4 : 0);
        int n2 = caps.GL_NVX_gpu_memory_info ? 1 : (this.memType = caps.GL_ATI_meminfo ? 2 : 0);
        if (caps.GL_NVX_gpu_memory_info) {
            this.descriptions = new String[]{"Dedicated", "Available", "Current available", "Evicted"};
            this.memoryValues = new String[this.descriptions.length];
            this.output = new String[this.descriptions.length];
            this.memType = 1;
        } else if (caps.GL_ATI_meminfo) {
            this.descriptions = new String[]{"Total free", "Largest available free block", "Total auxiliary", "Largest auxiliary free block"};
            this.memoryValues = new String[this.descriptions.length];
            this.output = new String[this.descriptions.length];
            this.memType = 2;
        } else {
            this.output = new String[]{"Memory data is unavailable"};
            this.memType = 0;
        }
    }

    @Override
    public void update() {
        if (this.memType == 0) {
            return;
        }
        if (++this.refreshTimer > this.ticksToRefresh) {
            switch (this.memType) {
                case 1: {
                    this.memoryValues[0] = MemoryUnit.MEGABYTES.formatSpacedSuffix(MemoryUnit.toBytes(GL11.glGetInteger((int)36935), MemoryUnit.KILOBYTES));
                    this.memoryValues[1] = MemoryUnit.MEGABYTES.formatSpacedSuffix(MemoryUnit.toBytes(GL11.glGetInteger((int)36936), MemoryUnit.KILOBYTES));
                    this.memoryValues[2] = MemoryUnit.MEGABYTES.formatSpacedSuffix(MemoryUnit.toBytes(GL11.glGetInteger((int)36937), MemoryUnit.KILOBYTES));
                    this.memoryValues[3] = MemoryUnit.MEGABYTES.formatSpacedSuffix(MemoryUnit.toBytes(GL11.glGetInteger((int)36939), MemoryUnit.KILOBYTES));
                    break;
                }
                case 2: {
                    IntBuffer buffer = ClientProxy.INT_BUFFER_16;
                    GL11.glGetInteger((int)34811, (IntBuffer)buffer);
                    for (int i = 0; i != 4; ++i) {
                        this.memoryValues[i] = MemoryUnit.MEGABYTES.formatSpacedSuffix(MemoryUnit.toBytes(buffer.get(), MemoryUnit.KILOBYTES));
                    }
                    buffer.rewind();
                }
            }
            this.refreshTimer = 0;
        }
        if ((this.refreshTimer - 5) % 2 == 0) {
            for (int i = 0; i != this.descriptions.length; ++i) {
                StringBuilder builder = new StringBuilder(this.refreshTimer < 5 ? "[V] " : ANIMATION[(this.refreshTimer - 5) % 8 / 2]);
                builder.append(this.descriptions[i]).append(": ").append(this.memoryValues[i]);
                this.output[i] = builder.toString();
            }
        }
    }

    public String[] getLines() {
        return this.output;
    }
}

