/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.plyushkinlog.standard;

import by.fxg.plyushkinlog.structure.IStorableInfo;
import by.fxg.plyushkinlog.structure.IStorableInfoSection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InfoSection
implements IStorableInfoSection {
    protected String name;
    protected final List<IStorableInfo> infoList = new ArrayList<IStorableInfo>();

    public InfoSection(String name) {
        this.name = name;
    }

    @Override
    public String getTypeName() {
        return "[SECTION]";
    }

    @Override
    public String getEntryName() {
        return this.name;
    }

    @Override
    public void flushData(Appendable out, String prefix, String depthPrefix) throws IOException {
        if (this.infoList.size() > 0) {
            this.write(out, depthPrefix, this.getTypeName(), " ", this.getEntryName(), " {");
            String nextDepthPrefix = this.format(depthPrefix, prefix);
            for (IStorableInfo info : this.infoList) {
                info.flushData(out, prefix, nextDepthPrefix);
            }
            this.write(out, depthPrefix, "} (", this.getEntryName(), ")");
        } else {
            this.write(out, depthPrefix, this.getTypeName(), " ", this.getEntryName(), " { EMPTY }");
        }
    }

    @Override
    public IStorableInfoSection addInfo(IStorableInfo info) {
        if (info != null) {
            this.infoList.add(info);
        }
        return this;
    }
}

