/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.plyushkinlog.standard;

import by.fxg.plyushkinlog.structure.IStorableInfo;
import by.fxg.plyushkinlog.structure.IStorableInfoSection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StringSection
implements IStorableInfoSection {
    protected String name;
    protected final List<String> infoList;

    public StringSection(String name) {
        this(name, new ArrayList<String>());
    }

    public StringSection(String name, List<String> info) {
        this.name = name;
        this.infoList = info;
    }

    @Override
    public String getTypeName() {
        return "[SECTION]";
    }

    @Override
    public String getEntryName() {
        return this.name;
    }

    @Override
    public void flushData(Appendable out, String prefix, String depthPrefix) throws IOException {
        if (this.infoList.size() > 0) {
            this.write(out, depthPrefix, this.getTypeName(), " ", this.getEntryName(), " {");
            String nextDepthPrefix = this.format(depthPrefix, prefix);
            for (String info : this.infoList) {
                this.write(out, nextDepthPrefix, info);
            }
            this.write(out, depthPrefix, "} (", this.getEntryName(), ")");
        } else {
            this.write(out, depthPrefix, this.getTypeName(), " ", this.getEntryName(), " { EMPTY }");
        }
    }

    @Override
    @Deprecated
    public IStorableInfoSection addInfo(IStorableInfo info) {
        return this;
    }

    public StringSection addInfo(String info) {
        this.infoList.add(info);
        return this;
    }
}

