/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.plyushkinlog.structure;

public enum MemoryUnit {
    BYTES(1L, "Bytes"),
    KILOBYTES(1024L, "KB"),
    MEGABYTES(0x100000L, "MB"),
    GIGABYTES(0x40000000L, "GB"),
    TERABYTES(0x10000000000L, "TB");

    private final long divider;
    private final String suffix;

    private MemoryUnit(long divider, String suffix) {
        this.divider = divider;
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String formatSpacedSuffix(long bytes) {
        return bytes / this.divider + " " + this.suffix;
    }

    public String format(long bytes) {
        return this.format(bytes, true);
    }

    public String format(long bytes, boolean writeSuffix) {
        if (writeSuffix) {
            return bytes / this.divider + this.suffix;
        }
        return "" + bytes / this.divider;
    }

    public static long toBytes(long value, MemoryUnit unit) {
        return value * unit.divider;
    }
}

