/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation;

import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.integration.RefinedRelocation;
import com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation.SortingBlockRegistry;
import com.jaquadro.minecraft.storagedrawers.integration.refinedrelocation.TileSortingDrawersStandard;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWood;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSortingDrawers
extends BlockDrawers {
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconSort;

    public BlockSortingDrawers(String blockName, int drawerCount, boolean halfDepth) {
        super(blockName, drawerCount, halfDepth);
        this.func_149647_a(RefinedRelocation.tabStorageDrawers);
    }

    public static boolean upgradeToSorting(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityDrawersStandard) || tile instanceof TileSortingDrawersStandard) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        TileEntityDrawersStandard oldDrawer = (TileEntityDrawersStandard)tile;
        TileSortingDrawersStandard newDrawer = new TileSortingDrawersStandard();
        NBTTagCompound tag = new NBTTagCompound();
        oldDrawer.func_145841_b(tag);
        newDrawer.func_145839_a(tag);
        world.func_147475_p(x, y, z);
        world.func_147468_f(x, y, z);
        Block sortingBlock = SortingBlockRegistry.resolveSortingBlock(block);
        if (sortingBlock != null) {
            world.func_147465_d(x, y, z, sortingBlock, meta, 3);
        }
        world.func_147455_a(x, y, z, (TileEntity)newDrawer);
        return true;
    }

    @Override
    public BlockType retrimType() {
        return BlockType.DrawersSorting;
    }

    @Override
    public TileSortingDrawersStandard createNewTileEntity(World world, int meta) {
        return new TileSortingDrawersStandard();
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        if (side == 1 && !this.halfDepth) {
            return this.iconSort[meta];
        }
        return super.func_149691_a(side, meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IIcon getIcon(IBlockAccess blockAccess, int x, int y, int z, int side, int level) {
        int meta = blockAccess.func_72805_g(x, y, z) % this.iconSort.length;
        if (side == 1 && !this.halfDepth) {
            return this.iconSort[meta];
        }
        return super.getIcon(blockAccess, x, y, z, side, level);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        super.func_149651_a(register);
        String[] subtex = BlockWood.field_150096_a;
        this.iconSort = new IIcon[subtex.length];
        for (int i = 0; i < subtex.length; ++i) {
            this.iconSort[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_sort");
        }
    }
}

