/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.plugins.te4;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.library.crafting.FluidType;
import tconstruct.library.crafting.Smeltery;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.world.TinkerWorld;

@GameRegistry.ObjectHolder(value="ThermalFoundation")
@Pulse(id="Tinkers Thermal Foundation Compatibility", description="Tinkers Construct compatibility for Thermal Foundation", modsRequired="ThermalFoundation", forced=true)
public class TinkersThermalFoundation {
    static final String TF_MOD_ID = "ThermalFoundation";

    @Handler
    public void preInit(FMLPreInitializationEvent event) {
        this.registerFluidType("Nickel", 400, TinkerSmeltery.moltenNickelFluid);
        this.registerFluidType("Lead", 400, TinkerSmeltery.moltenLeadFluid);
        this.registerFluidType("Silver", 400, TinkerSmeltery.moltenSilverFluid);
        this.registerFluidType("Platinum", 400, TinkerSmeltery.moltenShinyFluid);
        this.registerFluidType("Invar", 400, TinkerSmeltery.moltenInvarFluid);
        this.registerFluidType("Electrum", 400, TinkerSmeltery.moltenElectrumFluid);
        this.registerFluidType("Lumium", 370, TinkerSmeltery.moltenLumiumFluid);
        this.registerFluidType("Signalum", 450, TinkerSmeltery.moltenSignalumFluid);
        this.registerFluidType("Mithril", 800, TinkerSmeltery.moltenMithrilFluid);
        this.registerFluidType("Enderium", 1000, TinkerSmeltery.moltenEnderiumFluid);
    }

    @Handler
    public void init(FMLInitializationEvent event) {
        Fluid pyrotheumFluid = FluidRegistry.getFluid((String)"pyrotheum");
        Fluid cryotheumFluid = FluidRegistry.getFluid((String)"cryotheum");
        Fluid redstoneFluid = FluidRegistry.getFluid((String)"redstone");
        Fluid glowstoneFluid = FluidRegistry.getFluid((String)"glowstone");
        Fluid coalFluid = FluidRegistry.getFluid((String)"coal");
        Smeltery.addSmelteryFuel(pyrotheumFluid, 5000, 70);
        for (ItemStack stack : OreDictionary.getOres((String)"blockRedstone")) {
            Smeltery.addMelting(stack, Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j(), 3000, new FluidStack(redstoneFluid, 900));
        }
        for (ItemStack stack : OreDictionary.getOres((String)"dustRedstone")) {
            Smeltery.addMelting(stack, Blocks.field_150451_bX, stack.func_77960_j(), 2500, new FluidStack(redstoneFluid, 100));
        }
        for (ItemStack stack : OreDictionary.getOres((String)"glowstone")) {
            Smeltery.addMelting(stack, Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j(), 3000, new FluidStack(glowstoneFluid, 1000));
        }
        for (ItemStack stack : OreDictionary.getOres((String)"dustGlowstone")) {
            Smeltery.addMelting(stack, Blocks.field_150426_aN, stack.func_77960_j(), 2500, new FluidStack(glowstoneFluid, 250));
        }
        for (ItemStack stack : OreDictionary.getOres((String)"dustPyrotheum")) {
            Smeltery.addMelting(stack, Blocks.field_150426_aN, stack.func_77960_j(), 1299, new FluidStack(pyrotheumFluid, 100));
        }
        for (ItemStack stack : OreDictionary.getOres((String)"dustCryotheum")) {
            Smeltery.addMelting(stack, Blocks.field_150433_aE, stack.func_77960_j(), 4000, new FluidStack(cryotheumFluid, 100));
        }
        for (ItemStack stack : OreDictionary.getOres((String)"dustCoal")) {
            Smeltery.addMelting(stack, Blocks.field_150402_ci, stack.func_77960_j(), 4000, new FluidStack(coalFluid, 100));
        }
        int amount = 144;
        FluidStack result = new FluidStack(TinkerSmeltery.moltenInvarFluid, amount * 3);
        FluidStack part1 = new FluidStack(TinkerSmeltery.moltenIronFluid, amount * 2);
        FluidStack part2 = new FluidStack(TinkerSmeltery.moltenNickelFluid, amount);
        Smeltery.addAlloyMixing(result, part1, part2);
        result = new FluidStack(TinkerSmeltery.moltenElectrumFluid, amount * 2);
        part1 = new FluidStack(TinkerSmeltery.moltenGoldFluid, amount);
        part2 = new FluidStack(TinkerSmeltery.moltenSilverFluid, amount);
        Smeltery.addAlloyMixing(result, part1, part2);
        result = new FluidStack(TinkerSmeltery.moltenLumiumFluid, amount * 4);
        part1 = new FluidStack(TinkerSmeltery.moltenSilverFluid, amount);
        part2 = new FluidStack(TinkerSmeltery.moltenTinFluid, amount * 3);
        FluidStack part3 = new FluidStack(glowstoneFluid, 1000);
        Smeltery.addAlloyMixing(result, part1, part2, part3);
        result = new FluidStack(TinkerSmeltery.moltenSignalumFluid, amount * 4);
        part1 = new FluidStack(TinkerSmeltery.moltenSilverFluid, amount);
        part2 = new FluidStack(TinkerSmeltery.moltenCopperFluid, amount * 3);
        part3 = new FluidStack(redstoneFluid, 1000);
        Smeltery.addAlloyMixing(result, part1, part2, part3);
        result = new FluidStack(TinkerSmeltery.moltenEnderiumFluid, amount * 4);
        part1 = new FluidStack(TinkerSmeltery.moltenSilverFluid, amount);
        part2 = new FluidStack(TinkerSmeltery.moltenTinFluid, amount * 2);
        part3 = new FluidStack(TinkerSmeltery.moltenShinyFluid, amount);
        Smeltery.addAlloyMixing(result, part1, part2, part3, new FluidStack(TinkerSmeltery.moltenEnderFluid, 1000));
    }

    private void registerFluidType(String name, int temp, Fluid fluid) {
        ItemStack stack = GameRegistry.findItemStack((String)TF_MOD_ID, (String)("block" + name), (int)1);
        if (stack == null || stack.func_77973_b() == null) {
            stack = new ItemStack(TinkerWorld.metalBlock);
        }
        FluidType.registerFluidType(name, Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j(), temp, fluid, false);
    }
}

