/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.registry.BlockRegistry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXSparkle;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ItemFocusLumos
extends ItemFocusBasic {
    private static final AspectList COST = new AspectList().add(Aspect.AIR, 10).add(Aspect.FIRE, 25);

    public ItemFocusLumos() {
        this.func_77637_a(TaintedMagic.tabTM);
        this.func_77655_b("ItemFocusLumos");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusLumos");
    }

    public String getSortingHelper(ItemStack stack) {
        return "LUMOS" + super.getSortingHelper(stack);
    }

    public int getFocusColor(ItemStack stack) {
        return 13226744;
    }

    public AspectList getVisCost(ItemStack stack) {
        return COST;
    }

    public int getActivationCooldown(ItemStack stack) {
        return 1000;
    }

    public boolean isVisCostPerTick(ItemStack stack) {
        return false;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack stack) {
        return ItemFocusBasic.WandFocusAnimation.WAVE;
    }

    public ItemStack onFocusRightClick(ItemStack stack, World world, EntityPlayer player, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = mop.field_72311_b;
            int y = mop.field_72312_c;
            int z = mop.field_72309_d;
            if (!world.func_147439_a(x, y, z).func_149688_o().func_76222_j()) {
                switch (mop.field_72310_e) {
                    case 0: {
                        --y;
                        break;
                    }
                    case 1: {
                        ++y;
                        break;
                    }
                    case 2: {
                        --z;
                        break;
                    }
                    case 3: {
                        ++z;
                        break;
                    }
                    case 4: {
                        --x;
                        break;
                    }
                    case 5: {
                        ++x;
                    }
                }
            }
            if (world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z) && wand.consumeAllVis(stack, player, this.getVisCost(stack), true, false)) {
                if (!world.field_72995_K) {
                    world.func_147465_d(x, y, z, BlockRegistry.BlockLumos, 0, 3);
                }
                world.func_72956_a((Entity)player, "thaumcraft:ice", 0.3f, 1.1f + world.field_73012_v.nextFloat() * 0.1f);
                for (int a = 0; a < 9; ++a) {
                    if (!world.field_72995_K) continue;
                    this.spawnLumosParticles(world, x, y, z);
                }
            }
        }
        player.func_71038_i();
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    void spawnLumosParticles(World world, double x, double y, double z) {
        FXSparkle fx = new FXSparkle(world, x + (double)world.field_73012_v.nextFloat(), y + (double)world.field_73012_v.nextFloat(), z + (double)world.field_73012_v.nextFloat(), 1.75f, 6, 3 + world.field_73012_v.nextInt(3));
        fx.setGravity(0.1f);
        ParticleEngine.instance.addEffect(world, (EntityFX)fx);
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack stack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal};
            }
        }
        return null;
    }
}

