/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.entities.EntityHomingShard;
import taintedmagic.common.items.wand.foci.TMFocusUpgrades;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXSparkle;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.utils.EntityUtils;

public class ItemFocusVisShard
extends ItemFocusBasic {
    private static final AspectList COST = new AspectList().add(Aspect.FIRE, 10).add(Aspect.ENTROPY, 10).add(Aspect.AIR, 10);
    private static final AspectList COST_PERSISTENT = COST.copy().add(Aspect.WATER, 10);

    public ItemFocusVisShard() {
        this.func_77637_a(TaintedMagic.tabTM);
        this.func_77655_b("ItemFocusVisShard");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusVisShard");
    }

    public String getSortingHelper(ItemStack stack) {
        return "SHARD" + super.getSortingHelper(stack);
    }

    public int getFocusColor(ItemStack stack) {
        return 10037693;
    }

    public int getActivationCooldown(ItemStack stack) {
        return 300;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack stack) {
        return ItemFocusBasic.WandFocusAnimation.WAVE;
    }

    public ItemStack onFocusRightClick(ItemStack stack, World world, EntityPlayer player, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        Entity look = EntityUtils.getPointedEntity((World)player.field_70170_p, (Entity)player, (double)0.0, (double)32.0, (float)1.1f);
        if (look != null && look instanceof EntityLivingBase) {
            if (wand.consumeAllVis(stack, player, this.getVisCost(stack), true, false)) {
                EntityHomingShard shard = new EntityHomingShard(world, (EntityLivingBase)player, (EntityLivingBase)look, wand.getFocusPotency(stack), this.isUpgradedWith(wand.getFocusItem(stack), TMFocusUpgrades.persistent));
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)shard);
                }
                world.func_72956_a((Entity)shard, "taintedmagic:shard", 0.3f, 1.1f + world.field_73012_v.nextFloat() * 0.1f);
                if (world.field_72995_K) {
                    this.spawnParticles(world, shard.field_70165_t, shard.field_70163_u, shard.field_70161_v);
                }
            }
            player.func_71038_i();
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    void spawnParticles(World world, double x, double y, double z) {
        for (int a = 0; a < 18; ++a) {
            FXSparkle fx = new FXSparkle(world, x + (double)world.field_73012_v.nextFloat(), y + (double)world.field_73012_v.nextFloat(), z + (double)world.field_73012_v.nextFloat(), 1.75f, 0, 3 + world.field_73012_v.nextInt(3));
            fx.setGravity(0.1f);
            ParticleEngine.instance.addEffect(world, (EntityFX)fx);
        }
    }

    public AspectList getVisCost(ItemStack stack) {
        return this.isUpgradedWith(stack, TMFocusUpgrades.persistent) ? COST_PERSISTENT : COST;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack stack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, TMFocusUpgrades.persistent};
            }
        }
        return null;
    }
}

