/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.crafting;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;

public class InfusionRecipe {
    public AspectList aspects;
    public String research;
    public Object recipeOutput;
    public int instability;
    public ItemStack[] components;
    public ItemStack recipeInput;
    public boolean fuzzy = true;

    public InfusionRecipe(String research, Object output, int inst, AspectList aspects2, ItemStack input, ItemStack[] recipe) {
        this.research = research;
        this.recipeOutput = output;
        this.recipeInput = input;
        this.aspects = aspects2;
        this.components = recipe;
        this.instability = inst;
    }

    public static boolean areItemStacksEqual(ItemStack stack0, ItemStack stack1, boolean fuzzy) {
        ItemStack[] ores;
        int od;
        if (stack0 == null && stack1 != null) {
            return false;
        }
        if (stack0 != null && stack1 == null) {
            return false;
        }
        if (stack0 == null && stack1 == null) {
            return true;
        }
        boolean t1 = ThaumcraftApiHelper.areItemStackTagsEqualForCrafting(stack0, stack1);
        if (!t1) {
            return false;
        }
        if (fuzzy && (od = OreDictionary.getOreID((ItemStack)stack0)) != -1 && ThaumcraftApiHelper.containsMatch(false, new ItemStack[]{stack1}, ores = OreDictionary.getOres((Integer)od).toArray(new ItemStack[0]))) {
            return true;
        }
        boolean damage = stack0.func_77960_j() == stack1.func_77960_j() || stack1.func_77960_j() == Short.MAX_VALUE;
        return stack0.func_77973_b() == stack1.func_77973_b() && damage && stack0.field_77994_a <= stack0.func_77976_d();
    }

    public boolean isFuzzy() {
        return this.fuzzy;
    }

    public void setFuzzy(boolean fuzzy) {
        this.fuzzy = fuzzy;
    }

    public boolean matches(ArrayList<ItemStack> input, ItemStack central, World world, EntityPlayer player) {
        if (this.getRecipeInput() == null) {
            return false;
        }
        if (this.research.length() > 0 && !ThaumcraftApiHelper.isResearchComplete(player.func_70005_c_(), this.research)) {
            return false;
        }
        ItemStack i2 = central.func_77946_l();
        if (this.getRecipeInput().func_77960_j() == Short.MAX_VALUE) {
            i2.func_77964_b(Short.MAX_VALUE);
        }
        if (!InfusionRecipe.areItemStacksEqual(i2, this.getRecipeInput(), this.isFuzzy())) {
            return false;
        }
        ArrayList<ItemStack> ii = new ArrayList<ItemStack>();
        for (ItemStack is : input) {
            ii.add(is.func_77946_l());
        }
        for (ItemStack comp : this.getComponents()) {
            boolean b = false;
            for (int a = 0; a < ii.size(); ++a) {
                i2 = ((ItemStack)ii.get(a)).func_77946_l();
                if (comp.func_77960_j() == Short.MAX_VALUE) {
                    i2.func_77964_b(Short.MAX_VALUE);
                }
                if (!InfusionRecipe.areItemStacksEqual(i2, comp, this.isFuzzy())) continue;
                ii.remove(a);
                b = true;
                break;
            }
            if (b) continue;
            return false;
        }
        return ii.size() == 0;
    }

    public Object getRecipeOutput() {
        return this.getRecipeOutput(this.getRecipeInput());
    }

    public AspectList getAspects() {
        return this.getAspects(this.getRecipeInput());
    }

    public int getInstability() {
        return this.getInstability(this.getRecipeInput());
    }

    public String getResearch() {
        return this.research;
    }

    public ItemStack getRecipeInput() {
        return this.recipeInput;
    }

    public ItemStack[] getComponents() {
        return this.components;
    }

    public Object getRecipeOutput(ItemStack input) {
        return this.recipeOutput;
    }

    public AspectList getAspects(ItemStack input) {
        return this.aspects;
    }

    public int getInstability(ItemStack input) {
        return this.instability;
    }
}

