/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.container;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.container.InventoryFocusPouch;
import thaumcraft.common.container.SlotLimitedByClass;
import thaumcraft.common.items.wands.ItemFocusPouch;

public class ContainerFocusPouch
extends Container {
    private World worldObj;
    private int posX;
    private int posY;
    private int posZ;
    private int blockSlot;
    public IInventory input = new InventoryFocusPouch(this);
    ItemStack pouch;
    EntityPlayer player;
    private static final String NBT_KEY_UID = "UID";
    private int blockedSlot;

    public void func_75130_a(IInventory inventory) {
        ((ItemFocusPouch)this.pouch.func_77973_b()).setInventory(this.pouch, ((InventoryFocusPouch)this.input).stackList);
        if (this.player != null && this.func_75145_c(this.player) && this.player.func_70694_bm() != null && this.player.func_70694_bm().func_77969_a(this.pouch)) {
            this.player.func_70062_b(0, this.pouch);
        }
        super.func_75130_a(inventory);
    }

    private static boolean isSameItemInventory(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        if (base.func_77973_b() != comparison.func_77973_b()) {
            return false;
        }
        if (!base.func_77942_o() || !comparison.func_77942_o()) {
            return false;
        }
        String baseUID = base.func_77978_p().func_74779_i(NBT_KEY_UID);
        String comparisonUID = comparison.func_77978_p().func_74779_i(NBT_KEY_UID);
        return baseUID != null && comparisonUID != null && baseUID.equals(comparisonUID);
    }

    public ContainerFocusPouch(InventoryPlayer iinventory, World world, int x, int y, int z) {
        this.worldObj = world;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.player = iinventory.field_70458_d;
        this.pouch = iinventory.func_70448_g();
        this.blockSlot = iinventory.field_70461_c + 45;
        if (this.pouch != null && this.pouch.func_77973_b() instanceof ItemFocusPouch) {
            NBTTagCompound nbt;
            if (!this.pouch.func_77942_o()) {
                this.pouch.func_77982_d(new NBTTagCompound());
            }
            if (!(nbt = this.pouch.func_77978_p()).func_74764_b(NBT_KEY_UID)) {
                nbt.func_74778_a(NBT_KEY_UID, UUID.randomUUID().toString());
            }
        }
        for (int a = 0; a < 18; ++a) {
            this.func_75146_a(new SlotLimitedByClass(ItemFocusBasic.class, this.input, a, 37 + a % 6 * 18, 51 + a / 6 * 18));
        }
        this.bindPlayerInventory(iinventory);
        if (!world.field_72995_K) {
            try {
                ((InventoryFocusPouch)this.input).stackList = ((ItemFocusPouch)this.pouch.func_77973_b()).getInventory(this.pouch);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.func_75130_a(this.input);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 151 + i * 18));
            }
        }
        int currentSlot = inventoryPlayer.field_70461_c;
        for (int i = 0; i < 9; ++i) {
            Slot slot = this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 209));
            if (slot.getSlotIndex() != currentSlot) continue;
            this.blockedSlot = slot.field_75222_d;
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        if (slot == this.blockSlot) {
            return null;
        }
        if (slot == this.blockedSlot) {
            return null;
        }
        if (!this.func_75145_c(player)) {
            return null;
        }
        ItemStack stack = null;
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        if (slotObject != null && slotObject.func_75216_d()) {
            ItemStack stackInSlot = slotObject.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slot < 18 ? !this.input.func_94041_b(slot, stackInSlot) || !this.func_75135_a(stackInSlot, 18, this.field_75151_b.size(), true) : !this.input.func_94041_b(slot, stackInSlot) || !this.func_75135_a(stackInSlot, 0, 18, false)) {
                return null;
            }
            if (stackInSlot.field_77994_a == 0) {
                slotObject.func_75215_d(null);
            } else {
                slotObject.func_75218_e();
            }
        }
        return stack;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return ContainerFocusPouch.isSameItemInventory(this.pouch, player.func_71045_bC());
    }

    public ItemStack func_75144_a(int slot, int button, int buttonType, EntityPlayer player) {
        if (slot == this.blockSlot) {
            return null;
        }
        if (slot == this.blockedSlot) {
            return null;
        }
        if (buttonType == 2 && button == this.blockedSlot) {
            return null;
        }
        if (!this.func_75145_c(player)) {
            return null;
        }
        return super.func_75144_a(slot, button, buttonType, player);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.worldObj.field_72995_K) {
            ((ItemFocusPouch)this.pouch.func_77973_b()).setInventory(this.pouch, ((InventoryFocusPouch)this.input).stackList);
            if (this.player == null || !this.func_75145_c(this.player)) {
                return;
            }
            if (this.player.func_70694_bm() != null && this.player.func_70694_bm().func_77969_a(this.pouch)) {
                this.player.func_70062_b(0, this.pouch);
            }
            this.player.field_71071_by.func_70296_d();
        }
    }
}

