/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.glease.tc4tweak.asm.ASMUtils;
import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class ThaumcraftCraftingManagerVisitor
extends ClassVisitor {
    private static final Map<String, String> METHODS_TO_DEFLECT = ImmutableMap.of((Object)"getObjectTags", (Object)"(Lnet/minecraft/item/ItemStack;)Lthaumcraft/api/aspects/AspectList;", (Object)"findMatchingArcaneRecipe", (Object)"(Lnet/minecraft/inventory/IInventory;Lnet/minecraft/entity/player/EntityPlayer;)Lnet/minecraft/item/ItemStack;", (Object)"findMatchingArcaneRecipeAspects", (Object)"(Lnet/minecraft/inventory/IInventory;Lnet/minecraft/entity/player/EntityPlayer;)Lthaumcraft/api/aspects/AspectList;");

    public ThaumcraftCraftingManagerVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (METHODS_TO_DEFLECT.getOrDefault(name, "").equals(desc)) {
            TC4Transformer.log.debug("Replacing {}", new Object[]{name});
            ASMUtils.writeMethodDeflected("net/glease/tc4tweak/asm/ASMCallhookServer", name, mv, null, desc);
            return null;
        }
        return mv;
    }
}

