/*
 * Decompiled with CFR 0.152.
 */
package tb.common.item.foci;

import DummyCore.Utils.MiscUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.items.wands.WandManager;

public class FociActivation
extends ItemFocusBasic {
    public int getFocusColor(ItemStack focusstack) {
        return 0xAAAAAA;
    }

    public String getSortingHelper(ItemStack focusstack) {
        String out = "AC";
        for (short id : this.getAppliedUpgrades(focusstack)) {
            out = out + id;
        }
        return out;
    }

    public AspectList getVisCost(ItemStack focusstack) {
        return new AspectList().add(Aspect.ORDER, 5).add(Aspect.EARTH, 10);
    }

    public int getActivationCooldown(ItemStack focusstack) {
        return 0;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack focusstack, int rank) {
        return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
    }

    public ItemStack onFocusRightClick(ItemStack wandstack, World world, EntityPlayer player, MovingObjectPosition movingobjectposition) {
        if (wandstack == null) {
            return wandstack;
        }
        if (player == null) {
            return wandstack;
        }
        if (player.func_70093_af()) {
            if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                NBTTagCompound fociTag = MiscUtils.getStackTag((ItemStack)wandstack).func_74775_l("focus").func_74775_l("tag");
                fociTag.func_74768_a("blockX", movingobjectposition.field_72311_b);
                fociTag.func_74768_a("blockY", movingobjectposition.field_72312_c);
                fociTag.func_74768_a("blockZ", movingobjectposition.field_72309_d);
                fociTag.func_74768_a("dim", player.field_71093_bK);
                ((NBTTagCompound)MiscUtils.getStackTag((ItemStack)wandstack).func_74781_a("focus")).func_74782_a("tag", (NBTBase)fociTag);
                player.func_71038_i();
                WandManager.consumeVisFromInventory((EntityPlayer)player, (AspectList)new AspectList().add(Aspect.ORDER, 100));
            }
        } else {
            NBTTagCompound fociTag = MiscUtils.getStackTag((ItemStack)wandstack).func_74775_l("focus").func_74775_l("tag");
            if (fociTag.func_74764_b("blockX")) {
                int x = fociTag.func_74762_e("blockX");
                int y = fociTag.func_74762_e("blockY");
                int z = fociTag.func_74762_e("blockZ");
                ItemStack foci = ItemStack.func_77949_a((NBTTagCompound)MiscUtils.getStackTag((ItemStack)wandstack).func_74775_l("focus"));
                int potencyLevel = this.getUpgradeLevel(foci, FocusUpgradeType.potency);
                int maxRange = 32 * (potencyLevel + 1);
                double range = player.func_70011_f((double)x, (double)y, (double)z);
                int aspectCost = 10;
                if (!WandManager.consumeVisFromInventory((EntityPlayer)player, (AspectList)new AspectList().add(Aspect.EARTH, aspectCost).add(Aspect.ORDER, aspectCost / 2))) {
                    return wandstack;
                }
                if (range > (double)maxRange) {
                    if (player.field_70170_p.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"tb.txt.tooFar")));
                    }
                    return wandstack;
                }
                int dim = fociTag.func_74762_e("dim");
                if (dim != player.field_71093_bK) {
                    if (player.field_70170_p.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"tb.txt.wrongDimension")));
                    }
                    return wandstack;
                }
                if (world.func_72904_c(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1) && world.func_72899_e(x, y, z)) {
                    Block b = world.func_147439_a(x, y, z);
                    Vec3 vec = player.func_70040_Z();
                    b.func_149727_a(world, x, y, z, player, 0, (float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c);
                }
                foci = null;
            }
        }
        return wandstack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
        this.icon = reg.func_94245_a(this.func_111208_A());
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        NBTTagCompound tag = MiscUtils.getStackTag((ItemStack)stack);
        if (tag.func_74764_b("blockX")) {
            list.add("X: " + tag.func_74762_e("blockX"));
            list.add("Y: " + tag.func_74762_e("blockY"));
            list.add("Z: " + tag.func_74762_e("blockZ"));
            list.add("Dim: " + tag.func_74762_e("dim"));
        }
    }
}

