/*
 * Decompiled with CFR 0.152.
 */
package thaumic.tinkerer.common.compat;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.aspects.Aspect;
import thaumic.tinkerer.common.core.helper.AspectCropLootManager;

@ZenClass(value="mods.thaumictinkerer.InfusedSeeds")
public class MineTweaker {
    @ZenMethod
    public static void addDrop(String aspectType, IItemStack drop, double chance) {
        if (aspectType == null) {
            return;
        }
        Aspect seedType = Aspect.getAspect((String)aspectType.toLowerCase());
        if (seedType == null) {
            MineTweakerAPI.logError((String)("[TT] Aspect " + aspectType.toLowerCase() + " not found!"));
            return;
        }
        ItemStack stack = MineTweaker.toMCStack(drop);
        if (stack == null) {
            MineTweakerAPI.logError((String)"[TT] Drop can't be null!");
            return;
        }
        if (AspectCropLootManager.hasAspectLoot(seedType, stack)) {
            MineTweakerAPI.logWarning((String)"[TT] Recipe already exists, skip it.");
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(seedType, stack, chance));
    }

    @ZenMethod
    public static void removeDrop(String aspectType, IItemStack drop) {
        if (aspectType == null) {
            return;
        }
        Aspect seedType = Aspect.getAspect((String)aspectType.toLowerCase());
        if (seedType == null) {
            MineTweakerAPI.logError((String)("[TT] Aspect " + aspectType.toLowerCase() + " not found!"));
            return;
        }
        ItemStack stack = MineTweaker.toMCStack(drop);
        if (!AspectCropLootManager.hasAspectLoot(seedType, stack)) {
            MineTweakerAPI.logWarning((String)("[TT] " + aspectType.toLowerCase() + " InfusedSeeds recipe for " + stack.func_82833_r() + " not found, skip it."));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Remove(seedType, stack));
    }

    @ZenMethod
    public static void removeDrop(String aspectType) {
        if (aspectType == null) {
            return;
        }
        Aspect seedType = Aspect.getAspect((String)aspectType.toLowerCase());
        if (seedType == null) {
            MineTweakerAPI.logError((String)("[TT] Aspect " + aspectType.toLowerCase() + " not found!"));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RemoveAspect(seedType));
    }

    @ZenMethod
    public static void removeDrop() {
        MineTweakerAPI.apply((IUndoableAction)new RemoveAll());
    }

    private static ItemStack toMCStack(IItemStack item) {
        if (item == null) {
            return null;
        }
        Object internal = item.getInternal();
        if (internal instanceof ItemStack) {
            return (ItemStack)internal;
        }
        MineTweakerAPI.getLogger().logError("Not a valid item stack: " + item);
        return null;
    }

    private static class Add
    implements IUndoableAction {
        private final Aspect seedType;
        private final ItemStack drop;
        private final double chance;

        private Add(Aspect seedType, ItemStack drop, double chance) {
            this.seedType = seedType;
            this.drop = drop;
            this.chance = chance;
        }

        public void apply() {
            AspectCropLootManager.addAspectLoot(this.seedType, this.drop, this.chance);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            AspectCropLootManager.removeAspectLoot(this.seedType, this.drop);
        }

        public String describe() {
            return "[TT] Adding drop " + this.drop.func_82833_r() + " to InfusedSeeds " + this.seedType.getName();
        }

        public String describeUndo() {
            return "[TT] Un-Adding drop " + this.drop.func_82833_r() + " to InfusedSeeds " + this.seedType.getName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveAll
    implements IUndoableAction {
        private final HashMap<Aspect, HashMap<ItemStack, Double>> chance = new HashMap();

        private RemoveAll() {
        }

        public void apply() {
            for (Aspect aspect : Aspect.aspects.values()) {
                this.chance.put(aspect, AspectCropLootManager.removeAspectLoot(aspect));
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (Map.Entry<Aspect, HashMap<ItemStack, Double>> map : this.chance.entrySet()) {
                for (Map.Entry<ItemStack, Double> items : map.getValue().entrySet()) {
                    AspectCropLootManager.addAspectLoot(map.getKey(), items.getKey(), items.getValue());
                }
            }
        }

        public String describe() {
            return "[TT] Remove all drop from all InfusedSeeds";
        }

        public String describeUndo() {
            return "[TT] Un-Remove all drop from all InfusedSeeds";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveAspect
    implements IUndoableAction {
        private final Aspect seedType;
        private final HashMap<ItemStack, Double> chance = new HashMap();

        private RemoveAspect(Aspect seedType) {
            this.seedType = seedType;
        }

        public void apply() {
            HashSet<ItemStack> iterator = new HashSet<ItemStack>(AspectCropLootManager.getItems(this.seedType).keySet());
            for (ItemStack stack : iterator) {
                this.chance.putAll(AspectCropLootManager.removeAspectLoot(this.seedType, stack));
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (Map.Entry<ItemStack, Double> map : this.chance.entrySet()) {
                AspectCropLootManager.addAspectLoot(this.seedType, map.getKey(), map.getValue());
            }
        }

        public String describe() {
            return "[TT] Remove all drop from InfusedSeeds " + this.seedType.getName();
        }

        public String describeUndo() {
            return "[TT] Un-Remove all drop from InfusedSeeds " + this.seedType.getName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    implements IUndoableAction {
        private final Aspect seedType;
        private final ItemStack drop;
        private final HashMap<ItemStack, Double> chance = new HashMap();

        private Remove(Aspect seedType, ItemStack drop) {
            this.seedType = seedType;
            this.drop = drop;
        }

        public void apply() {
            this.chance.putAll(AspectCropLootManager.removeAspectLoot(this.seedType, this.drop));
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (Map.Entry<ItemStack, Double> map : this.chance.entrySet()) {
                AspectCropLootManager.addAspectLoot(this.seedType, map.getKey(), map.getValue());
            }
        }

        public String describe() {
            return "[TT] Remove drop " + this.drop.func_82833_r() + " from InfusedSeeds " + this.seedType.getName();
        }

        public String describeUndo() {
            return "[TT] Un-Remove drop " + this.drop.func_82833_r() + " from InfusedSeeds " + this.seedType.getName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

