/*
 * Decompiled with CFR 0.152.
 */
package thaumic.tinkerer.common.compat.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.UtilsFX;
import thaumic.tinkerer.common.ThaumicTinkerer;
import thaumic.tinkerer.common.core.helper.AspectCropLootManager;
import thaumic.tinkerer.common.item.ItemInfusedSeeds;

public class CropLootViewer
extends TemplateRecipeHandler {
    private static final Item INFUSED_SEED = ThaumicTinkerer.registry.getFirstItemFromClass(ItemInfusedSeeds.class);
    private static final String USER_NAME = Minecraft.func_71410_x().func_110432_I().func_111285_a();

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ThaumcraftApiHelper.isResearchComplete((String)USER_NAME, (String)"INFUSED_POTIONS") && ingredient.func_77973_b().equals(INFUSED_SEED)) {
            Aspect aspect = ItemInfusedSeeds.getAspect(ingredient);
            if (aspect == null || !ThaumcraftApiHelper.hasDiscoveredAspect((String)USER_NAME, (Aspect)aspect)) {
                return;
            }
            int page = 0;
            while (true) {
                CachedCrops recipe = new CachedCrops(aspect, page++);
                if (recipe.drops.isEmpty()) break;
                this.arecipes.add(recipe);
            }
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (ThaumcraftApiHelper.isResearchComplete((String)USER_NAME, (String)"INFUSED_POTIONS")) {
            for (Aspect aspect : ThaumcraftApiHelper.getDiscoveredAspects((String)USER_NAME).getAspects()) {
                ItemStack[] drops = AspectCropLootManager.getItems(aspect).keySet().toArray(new ItemStack[0]);
                for (int index = 0; index < drops.length; ++index) {
                    if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)result, (ItemStack)drops[index])) continue;
                    this.arecipes.add(new CachedCrops(aspect, index / 27));
                }
            }
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("ThaumicTinkerer.croploot.drops") && ThaumcraftApiHelper.isResearchComplete((String)USER_NAME, (String)"INFUSED_POTIONS")) {
            block0: for (Aspect aspect : ThaumcraftApiHelper.getDiscoveredAspects((String)USER_NAME).getAspects()) {
                int page = 0;
                while (true) {
                    CachedCrops recipe = new CachedCrops(aspect, page++);
                    if (recipe.drops.isEmpty()) continue block0;
                    this.arecipes.add(recipe);
                }
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 18, 18, 13), "ThaumicTinkerer.croploot.drops", new Object[0]));
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> info, int recipeID) {
        TemplateRecipeHandler.CachedRecipe recipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeID);
        if (recipe instanceof CachedCrops) {
            CachedCrops drops = (CachedCrops)recipe;
            for (int index = 0; index < drops.getOtherStacks().size(); ++index) {
                if (!drops.getOtherStacks().get((int)index).item.equals(stack)) continue;
                info.add(StatCollector.func_74837_a((String)"ThaumicTinkerer.croploot.info", (Object[])new Object[]{drops.chances[index], drops.maxAmounts[index]}));
                break;
            }
        }
        return info;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)162, (int)85);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        Aspect aspect = ((CachedCrops)((Object)this.arecipes.get((int)recipe))).aspect;
        if (aspect != null) {
            UtilsFX.drawTag((int)55, (int)1, (Aspect)aspect, (float)0.0f, (int)0, (double)1.0);
            GuiDraw.drawString((String)aspect.getName(), (int)91, (int)4, (int)0, (boolean)false);
        }
    }

    public String getGuiTexture() {
        return "ttinkerer:textures/gui/dropViewer.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"ThaumicTinkerer.croploot.drops");
    }

    public class CachedCrops
    extends TemplateRecipeHandler.CachedRecipe {
        public final PositionedStack seed;
        public final List<PositionedStack> drops;
        public final Aspect aspect;
        public final int[] maxAmounts;
        public final double[] chances;

        public CachedCrops(Aspect aspect, int page) {
            super((TemplateRecipeHandler)CropLootViewer.this);
            this.drops = new ArrayList<PositionedStack>();
            this.maxAmounts = new int[27];
            this.chances = new double[27];
            this.seed = new PositionedStack((Object)ItemInfusedSeeds.getStackFromAspect(aspect), 73, 1);
            this.aspect = aspect;
            HashMap<ItemStack, Double> data = AspectCropLootManager.getItems(aspect);
            ItemStack[] items = data.keySet().toArray(new ItemStack[0]);
            for (int index = page * 27; index < Math.min(page * 27 + 27, items.length); ++index) {
                int itemNumber = index - page * 27;
                this.chances[itemNumber] = data.getOrDefault(items[index], 0.0);
                ItemStack output = items[index].func_77946_l();
                this.maxAmounts[itemNumber] = output.field_77994_a;
                output.field_77994_a = 1;
                this.drops.add(new PositionedStack((Object)output, 1 + itemNumber % 9 * 18, 32 + itemNumber / 9 * 18));
            }
        }

        public PositionedStack getIngredient() {
            return this.seed;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.drops;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

