/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.ulysses.client.gui.elements;

import by.fxg.basicfml.gui.ShapeDrawer;
import by.fxg.basicfml.gui.elements.GUIElement;
import by.fxg.basicfml.math.Rectangle;
import by.fxg.basicfml.math.Vector2;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;

public class ElementCalendar
extends GUIElement {
    private static final int COLUMNS = 7;
    private static final int ROWS = 6;
    protected Rectangle transform = new Rectangle();
    protected Rectangle selectPanelTransform = new Rectangle();
    protected Vector2 buttonTransform = new Vector2();
    protected Consumer<LocalDate> callback = null;
    protected Function<LocalDate, Boolean> specialDateCallback = date -> false;
    @Nonnull
    protected YearMonth dateToDisplay;
    @Nonnull
    protected LocalDate[] displayDays = new LocalDate[42];
    protected int displayMonthFirstIndex = 0;
    protected int displayMonthLastIndex = 0;
    @Nullable
    protected LocalDate selectedIndexPointer = null;

    public ElementCalendar(@Nonnull YearMonth dateToDisplay) {
        this.setDisplayDate(dateToDisplay);
    }

    public ElementCalendar(@Nonnull YearMonth dateToDisplay, float x, float y, float width, float height) {
        this(dateToDisplay);
        this.setTransform(x, y, width, height);
    }

    @Nonnull
    public ElementCalendar setTransform(float x, float y, float width, float height) {
        this.transform.set(x, y, width, height);
        this.buttonTransform.set(width / 7.0f, height / 6.0f);
        return this;
    }

    @Nonnull
    public ElementCalendar setCallback(Consumer<LocalDate> callback) {
        this.callback = callback;
        return this;
    }

    @Nonnull
    public ElementCalendar setSpecialDateCallback(Function<LocalDate, Boolean> specialDateCallback) {
        this.specialDateCallback = specialDateCallback;
        return this;
    }

    @Nonnull
    public YearMonth getDisplayDate() {
        return this.dateToDisplay;
    }

    @Nullable
    public LocalDate getSelectedDay() {
        return this.selectedIndexPointer;
    }

    @Nonnull
    public ElementCalendar setDisplayDate(@Nonnull YearMonth dateToDisplay) {
        this.dateToDisplay = dateToDisplay;
        this.displayMonthFirstIndex = dateToDisplay.atDay(1).getDayOfWeek().ordinal();
        this.displayMonthLastIndex = this.displayMonthFirstIndex + dateToDisplay.lengthOfMonth();
        LocalDate firstDate = dateToDisplay.atDay(1).minusDays(this.displayMonthFirstIndex);
        for (int i = 0; i != this.displayDays.length; ++i) {
            this.displayDays[i] = firstDate.plusDays(i);
            if (this.selectedIndexPointer == null || !this.displayDays[i].isEqual(this.selectedIndexPointer)) continue;
            this.selectedIndexPointer = this.displayDays[i];
        }
        return this;
    }

    @Nonnull
    public ElementCalendar setSelectedDay(@Nullable LocalDate selectedDay) {
        if (selectedDay == null) {
            this.selectedIndexPointer = null;
        } else {
            for (int i = 0; i != this.displayDays.length; ++i) {
                if (!this.displayDays[i].isEqual(selectedDay)) continue;
                if (this.callback != null) {
                    this.callback.accept(this.displayDays[i]);
                }
                this.selectedIndexPointer = this.displayDays[i];
                return this;
            }
        }
        return this;
    }

    public void render(FontRenderer fontRenderer, int x, int y, int mouseX, int mouseY) {
        int xIdx;
        int yIdx;
        int idx;
        int selectedIdx = -1;
        if (this.isMouseOver(this.transform, mouseX, mouseY) && (idx = (yIdx = (int)(((float)mouseY - this.transform.y) / this.buttonTransform.y)) * 7 + (xIdx = (int)(((float)mouseX - this.transform.x) / this.buttonTransform.x))) >= this.displayMonthFirstIndex && idx < this.displayMonthLastIndex) {
            selectedIdx = idx;
        }
        for (int week = 0; week != 6; ++week) {
            for (int day = 0; day != 7; ++day) {
                idx = week * 7 + day;
                String dayOfMonth = String.valueOf(this.displayDays[idx].getDayOfMonth());
                if (this.specialDateCallback.apply(this.displayDays[idx]).booleanValue()) {
                    ShapeDrawer.drawFilledRect((float)(this.transform.x + this.buttonTransform.x * (float)day + 1.0f), (float)(this.transform.y + this.buttonTransform.y * (float)week + 1.0f), (float)(this.buttonTransform.x - 2.0f), (float)(this.buttonTransform.y - 2.0f), (int)-1430546057);
                }
                if (selectedIdx == idx) {
                    ShapeDrawer.drawFilledRect((float)(this.transform.x + this.buttonTransform.x * (float)day), (float)(this.transform.y + this.buttonTransform.y * (float)week), (float)this.buttonTransform.x, (float)this.buttonTransform.y, (int)-1433892728);
                }
                if (this.displayDays[idx] == this.selectedIndexPointer) {
                    ShapeDrawer.drawFilledRect((float)(this.transform.x + this.buttonTransform.x * (float)day), (float)(this.transform.y + this.buttonTransform.y * (float)week), (float)this.buttonTransform.x, (float)this.buttonTransform.y, (int)-1435011209);
                }
                fontRenderer.func_78276_b(dayOfMonth, (int)(this.transform.x + this.buttonTransform.x * (float)day + this.buttonTransform.x / 2.0f - (float)fontRenderer.func_78256_a(dayOfMonth) / 2.0f) + 1, (int)(this.transform.y + this.buttonTransform.y * (float)week + this.buttonTransform.y / 2.0f - (float)fontRenderer.field_78288_b / 2.0f) + 1, idx >= this.displayMonthFirstIndex && idx < this.displayMonthLastIndex ? -14671840 : -8355712);
            }
        }
    }

    public boolean onMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (this.isMouseOver(this.transform, mouseX, mouseY)) {
            int yIdx = (int)(((float)mouseY - this.transform.y) / this.buttonTransform.y);
            int xIdx = (int)(((float)mouseX - this.transform.x) / this.buttonTransform.x);
            int idx = yIdx * 7 + xIdx;
            if (idx >= this.displayMonthFirstIndex && idx < this.displayMonthLastIndex) {
                if (this.callback != null) {
                    this.callback.accept(this.displayDays[idx]);
                }
                this.selectedIndexPointer = this.displayDays[idx];
            }
            return true;
        }
        return false;
    }
}

