/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.ulysses.client.gui.elements;

import by.fxg.basicfml.gui.ShapeDrawer;
import by.fxg.basicfml.gui.elements.GUIElement;
import by.fxg.basicfml.math.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.input.Mouse;

public class ElementScrollableList
extends GUIElement {
    protected static final int FONT_HEIGHT = 11;
    protected Rectangle transform = new Rectangle();
    protected List<String> variants = new ArrayList<String>();
    protected int selectedVariant = -1;
    protected float scroll = 0.0f;
    protected boolean isScrollAvailable = false;
    protected Consumer<Integer> callback = null;

    public ElementScrollableList() {
    }

    public ElementScrollableList(float x, float y, float width, float height) {
        this.setTransform(x, y, width, height);
    }

    @Nonnull
    public ElementScrollableList setTransform(float x, float y, float width, float height) {
        this.transform.set(x, y, width, height);
        return this;
    }

    @Nonnull
    public ElementScrollableList setCallback(Consumer<Integer> callback) {
        this.callback = callback;
        return this;
    }

    @Nonnull
    public ElementScrollableList clearVariants() {
        this.variants.clear();
        this.scroll = 0.0f;
        return this;
    }

    @Nonnull
    public ElementScrollableList addVariant(String variant) {
        this.variants.add(variant);
        this.isScrollAvailable = (float)(this.variants.size() * 11 + 4) - this.transform.height > 0.0f;
        return this;
    }

    @Nonnull
    public ElementScrollableList resetSelection() {
        this.selectedVariant = -1;
        return this;
    }

    @Nonnull
    public ElementScrollableList setSelection(int index) {
        if (index > -1 && index < this.variants.size()) {
            this.selectedVariant = index;
            if (this.callback != null) {
                this.callback.accept(this.selectedVariant);
            }
        }
        return this;
    }

    public void render(FontRenderer font, int x, int y, int mouseX, int mouseY) {
        int selectedPosY;
        if (this.isMouseOver(this.transform, mouseX, mouseY)) {
            if (this.isScrollAvailable) {
                float dWheel = Mouse.getDWheel();
                if (dWheel > 0.0f && this.scroll > 0.0f) {
                    this.scroll = Math.max(this.scroll - 7.5f, 0.0f);
                } else if (dWheel < 0.0f) {
                    this.scroll = Math.min(this.scroll + 7.5f, (float)(this.variants.size() * 11) - this.transform.height);
                }
            }
            int mouseIndex = (int)((float)mouseY - this.transform.y + this.scroll) / 11;
            int mousePosY = (int)(this.transform.y + 2.0f + (float)(11 * mouseIndex) - this.scroll);
            if (mouseIndex < this.variants.size() && this.transform.y < (float)mousePosY && this.transform.y + this.transform.height + 4.0f > (float)(mousePosY + 11)) {
                ShapeDrawer.drawFilledRect((float)this.transform.x, (float)(mousePosY - 2), (float)this.transform.width, (float)11.0f, (int)-8355712);
            }
        }
        if (this.selectedVariant > -1 && this.transform.y < (float)(selectedPosY = (int)(this.transform.y + 2.0f + (float)(11 * this.selectedVariant) - this.scroll)) && this.transform.y + this.transform.height + 4.0f > (float)(selectedPosY + 11)) {
            ShapeDrawer.drawFilledRect((float)this.transform.x, (float)(selectedPosY - 2), (float)this.transform.width, (float)11.0f, (int)-1435011209);
        }
        for (int i = 0; i != this.variants.size(); ++i) {
            int posY = (int)(this.transform.y + 2.0f + (float)(11 * i) - this.scroll);
            if (!(this.transform.y < (float)posY)) continue;
            if (!(this.transform.y + this.transform.height + 4.0f > (float)(posY + 11))) break;
            font.func_78276_b(this.variants.get(i), (int)this.transform.x + 2, posY, -12566464);
        }
    }

    public boolean onMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (this.isMouseOver(this.transform, mouseX, mouseY)) {
            int mouseIndex = (int)((float)mouseY - this.transform.y + this.scroll) / 11;
            int mousePosY = (int)(this.transform.y + 2.0f + (float)(11 * mouseIndex) - this.scroll);
            if (mouseIndex < this.variants.size() && this.transform.y < (float)mousePosY && this.transform.y + this.transform.height + 4.0f > (float)(mousePosY + 11) && this.selectedVariant != mouseIndex) {
                this.setSelection(mouseIndex);
            }
            return true;
        }
        return false;
    }
}

