/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.ulysses.client.gui.history;

import by.fxg.basicfml.gui.INetworkWiredGui;
import by.fxg.basicfml.gui.ShapeDrawer;
import by.fxg.basicfml.math.Interpolation;
import by.fxg.basicfml.math.TimeSince;
import by.fxg.basicfml.network.NetworkWiredScreenMessage;
import by.fxg.ulysses.Ulysses;
import by.fxg.ulysses.client.ClientProxy;
import by.fxg.ulysses.client.gui.elements.ElementButton;
import by.fxg.ulysses.client.gui.elements.ElementConfirmableButton;
import by.fxg.ulysses.client.utils.IntegrationDrawableButton;
import by.fxg.ulysses.common.inventory.ContainerCache;
import by.fxg.ulysses.common.network.PacketWiredGuiContainer;
import by.fxg.ulysses.common.player.InventoryToolsCache;
import by.fxg.ulysses.common.player.UlyssesPlayerData;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiInventoryHistory
extends GuiContainer
implements INetworkWiredGui {
    private static final ResourceLocation GUI_DRAWABLE_ICONS = new ResourceLocation("ulysses:gui/inventoryicons.png");
    private static final ResourceLocation DRAWABLE_CLICK_SOUND = new ResourceLocation("gui.button.press");
    private ResourceLocation guiTexture = ClientProxy.NO_TEXTURE;
    private String guiTitle = "\u041a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440";
    private int drawablesX;
    private int drawablesY;
    private int drawablesOffset;
    private TimeSince drawableClickCooldown = new TimeSince();
    private TimeSince notificationCooldown = new TimeSince();
    private String notification = null;
    protected final int inventoryTypeIndex;
    protected final InventoryToolsCache cache;
    protected ElementConfirmableButton btnTakeItems;
    protected ElementConfirmableButton btnTakeReplaceItems;
    protected ElementConfirmableButton btnGiveItems;
    protected ElementConfirmableButton btnGiveReplaceItems;
    protected List<ElementButton> elementButtons = new ArrayList<ElementButton>();
    private static final List<IntegrationDrawableButton> buttonsRegistry = new ArrayList<IntegrationDrawableButton>(){
        {
            this.add(new IntegrationDrawableButton("inventory", 0, 0, 0));
            this.add(new IntegrationDrawableButton("enderchest", 1, 0, 10));
        }
    };

    public GuiInventoryHistory(int inventoryTypeIndex, EntityPlayer containerViewer, ContainerCache container) {
        super((Container)container);
        this.inventoryTypeIndex = inventoryTypeIndex;
        this.cache = UlyssesPlayerData.get((EntityPlayer)containerViewer).inventoryToolsCache;
        this.btnTakeItems = new ElementConfirmableButton("\u0412\u0437\u044f\u0442\u044c \u0432\u0435\u0449\u0438").setCallback(this::onButtonCallback, 1);
        this.elementButtons.add(this.btnTakeItems);
        this.btnTakeReplaceItems = new ElementConfirmableButton("\u0412\u0437\u044f\u0442\u044c \u0432\u0435\u0449\u0438 (\u0437\u0430\u043c\u0435\u043d\u0430)").setCallback(this::onButtonCallback, 2);
        this.elementButtons.add(this.btnTakeReplaceItems);
        this.btnGiveItems = ((ElementConfirmableButton)new ElementConfirmableButton("\u0412\u044b\u0434\u0430\u0442\u044c \u0432\u0435\u0449\u0438").setCallback(this::onButtonCallback, 3)).setEnabled(this.cache.watchedUserOnlineStatus);
        this.elementButtons.add(this.btnGiveItems);
        this.btnGiveReplaceItems = ((ElementConfirmableButton)new ElementConfirmableButton("\u0412\u044b\u0434\u0430\u0442\u044c \u0432\u0435\u0449\u0438 (\u0437\u0430\u043c\u0435\u043d\u0430)").setCallback(this::onButtonCallback, 4)).setEnabled(this.cache.watchedUserOnlineStatus);
        this.elementButtons.add(this.btnGiveReplaceItems);
    }

    protected void setupGui(String guiTitle, int drawablesX, int drawablesY, int drawablesOffset, ResourceLocation guiTexture) {
        this.guiTitle = guiTitle;
        this.drawablesX = drawablesX;
        this.drawablesY = drawablesY;
        this.drawablesOffset = drawablesOffset;
        this.guiTexture = guiTexture;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.drawableClickCooldown.increase();
        this.notificationCooldown.increase();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.notification == null || this.notificationCooldown.isOver(70L)) {
            this.field_146289_q.func_78276_b(this.guiTitle, 19, 6, 0x404040);
        }
        this.field_146289_q.func_78276_b(this.cache.watchedUsername, 19, 17, 0x404040);
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.guiTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146297_k.field_71446_o.func_110577_a(GUI_DRAWABLE_ICONS);
        for (int i = 0; i != buttonsRegistry.size(); ++i) {
            IntegrationDrawableButton drawable = buttonsRegistry.get(i);
            if (drawable == null) continue;
            drawable.draw(Tessellator.field_78398_a, this.inventoryTypeIndex == drawable.inventoryTypeIndex, this.field_147003_i + this.drawablesX, this.field_147009_r + this.drawablesY + i * this.drawablesOffset);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.elementButtons.forEach(element -> element.render(this.field_146289_q, this.field_147003_i, this.field_147009_r, mouseX, mouseY));
        if (this.notification != null && !this.notificationCooldown.isOver(80L)) {
            int nSizeX = this.field_146289_q.func_78256_a(this.notification) + 4;
            int nSizeY = this.field_146289_q.field_78288_b + 1;
            long time = this.notificationCooldown.get();
            int alpha = time > 60L ? (int)Interpolation.exp5Out.apply(255.0f, 4.0f, (float)(time - 60L) / 20.0f) : 255;
            ShapeDrawer.drawFilledRect((float)(this.field_147003_i + 7), (float)(this.field_147009_r + 5), (float)nSizeX, (float)nSizeY, (int)(alpha << 24 | 0xFFFF00));
            this.field_146289_q.func_78276_b(this.notification, this.field_147003_i + 9, this.field_147009_r + 6, alpha << 24 | 0);
        }
    }

    protected void onButtonCallback(int buttonID) {
        this.sendWiredMessage(buttonID, buf -> ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)GuiInventoryHistory.buttonsRegistry.get((int)this.inventoryTypeIndex).inventoryType));
    }

    protected void func_73864_a(int x, int y, int buttonID) {
        if (Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() == null && buttonID == 0) {
            for (ElementButton elementButton : this.elementButtons) {
                if (!elementButton.onMouseClick(x, y, buttonID)) continue;
                return;
            }
            if (this.drawableClickCooldown.isOver(9L)) {
                for (int i = 0; i != buttonsRegistry.size(); ++i) {
                    IntegrationDrawableButton drawable = buttonsRegistry.get(i);
                    int posX = this.field_147003_i + this.drawablesX;
                    int posY = this.field_147009_r + this.drawablesY + i * this.drawablesOffset;
                    if (x < posX || posX + 10 < x || y < posY || posY + 10 < y) continue;
                    this.drawableClickCooldown.setZero();
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)DRAWABLE_CLICK_SOUND, (float)1.0f));
                    this.sendWiredMessage(0, buf -> ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)drawable.inventoryType));
                    return;
                }
            }
        }
        super.func_73864_a(x, y, buttonID);
    }

    public SimpleNetworkWrapper getWiredNetworkWrapper() {
        return Ulysses.NETWORK;
    }

    public NetworkWiredScreenMessage createNetworkWiredGuiContainerMessage() {
        return new PacketWiredGuiContainer();
    }

    public void onWiredMessage(int actionID) {
        switch (actionID) {
            case 0: {
                this.notification = "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432";
                break;
            }
            case 1: {
                this.notification = "\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e";
                break;
            }
            case 2: {
                this.notification = "\u041e\u0448\u0438\u0431\u043a\u0430, \u0438\u0433\u0440\u043e\u043a \u043e\u0444\u0444\u043b\u0430\u0439\u043d";
                break;
            }
            case 3: {
                this.notification = "\u041e\u0448\u0438\u0431\u043a\u0430, \u0441\u043e\u043e\u0431\u0449\u0438\u0442\u0435 \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443";
            }
        }
        this.notificationCooldown.setZero();
    }

    public static void registerDrawable(String inventoryType, int inventoryTypeIndex, int atlasX, int atlasY) {
        buttonsRegistry.add(new IntegrationDrawableButton(inventoryType, inventoryTypeIndex, atlasX, atlasY));
        Collections.sort(buttonsRegistry);
    }
}

