/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.ulysses.client.gui.history;

import by.fxg.basicfml.gui.Screen;
import by.fxg.basicfml.gui.elements.GUIElement;
import by.fxg.basicfml.math.TimeSince;
import by.fxg.ulysses.Ulysses;
import by.fxg.ulysses.client.gui.elements.ElementButton;
import by.fxg.ulysses.client.gui.elements.ElementCalendar;
import by.fxg.ulysses.client.gui.elements.ElementScrollableList;
import by.fxg.ulysses.common.network.PacketInventoryHistory_Request;
import by.fxg.ulysses.common.player.InventoryToolsCache;
import by.fxg.ulysses.common.player.UlyssesPlayerData;
import by.fxg.ulysses.common.util.InventoryHistoryEntry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.TextStyle;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class GuiInventoryHistoryExplorer
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("ulysses:gui/inventoryhistory/explorer.png");
    private final InventoryToolsCache adminData;
    private final Locale locale;
    private final TextStyle localeTextstyle;
    public ElementCalendar calendar;
    private ElementButton calendarMinus;
    private ElementButton calendarPlus;
    private ElementButton openHistory;
    public ElementScrollableList deathList;
    private String calendarTitle;
    private TimeSince packetCooldown = new TimeSince();
    @Nonnull
    public Pair<YearMonth, YearMonth> monthBoundaries = Pair.of((Object)YearMonth.now(), (Object)YearMonth.now());
    @Nonnull
    public Map<LocalDate, List<InventoryHistoryEntry>> monthEntries = Collections.EMPTY_MAP;
    private InventoryHistoryEntry selectedEntry = null;

    public GuiInventoryHistoryExplorer() {
        super(227, 201);
        this.adminData = UlyssesPlayerData.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).inventoryToolsCache;
        Locale localeRU = Locale.forLanguageTag("ru");
        this.locale = localeRU == null ? Locale.ENGLISH : localeRU;
        this.localeTextstyle = this.locale != Locale.ENGLISH ? TextStyle.FULL_STANDALONE : TextStyle.FULL;
        this.calendar = new ElementCalendar(YearMonth.now()).setCallback(this::onCalendarDaySelected).setSpecialDateCallback(this::isCalendarSpecialDay);
        this.elements.add(this.calendar);
        this.calendarMinus = new ElementButton("<").setCallback(this::onCalendarButtonCallback, -1);
        this.elements.add(this.calendarMinus);
        this.calendarPlus = new ElementButton(">").setCallback(this::onCalendarButtonCallback, 1);
        this.elements.add(this.calendarPlus);
        this.deathList = new ElementScrollableList().setCallback(this::onTimestampSelected);
        this.elements.add(this.deathList);
        this.openHistory = new ElementButton("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c").setCallback(this::onOpenHistory, 0).setEnabled(false);
        this.elements.add(this.openHistory);
        this.calendarTitle = this.calendar.getDisplayDate().getMonth().getDisplayName(this.localeTextstyle, this.locale);
    }

    public void netInitGui(Pair<YearMonth, YearMonth> monthBoundaries) {
        YearMonth shownYearMonth = YearMonth.now();
        if (((YearMonth)monthBoundaries.getValue()).isBefore(shownYearMonth)) {
            shownYearMonth = (YearMonth)monthBoundaries.getValue();
        }
        this.monthBoundaries = monthBoundaries;
        this.calendar.setDisplayDate(shownYearMonth);
        this.calendarTitle = this.calendar.getDisplayDate().getMonth().getDisplayName(this.localeTextstyle, this.locale);
        Ulysses.NETWORK.sendToServer((IMessage)PacketInventoryHistory_Request.retrieveDeathRecords(shownYearMonth));
    }

    public void init() {
        this.calendar.setTransform(this.x + 95, this.y + 40, 111.999f, 66.0f);
        this.calendarMinus.setTransform(this.x + 95, this.y + 30, 16.0f, 10.0f);
        this.calendarPlus.setTransform(this.x + 191, this.y + 30, 16.0f, 10.0f);
        this.deathList.setTransform(this.x + 6, this.y + 30, 85.0f, 161.0f);
        this.openHistory.setTransform(this.x + 95, this.y + 181, 126.0f, 10.0f);
        this.openHistory.setEnabled(this.selectedEntry != null);
    }

    public void update() {
        this.packetCooldown.increase();
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        this.field_146297_k.field_71446_o.func_110577_a(GUI_TEXTURE);
        this.func_73729_b(this.x, this.y, 0, 0, this.guiWidth, this.guiHeight);
        GL11.glEnable((int)3042);
        for (GUIElement element : this.elements) {
            element.render(this.field_146289_q, this.x, this.y, mouseX, mouseY);
        }
        this.drawCenteredText(this.calendarTitle, this.x + 151, this.y + 31, -14671840, false);
        if (this.selectedEntry != null) {
            this.field_146289_q.func_78276_b(String.format("\u0412\u0440\u0435\u043c\u044f: %02d\u0447 %02d\u043c %02d\u0441", this.selectedEntry.timestamp.getHour(), this.selectedEntry.timestamp.getMinute(), this.selectedEntry.timestamp.getSecond()), this.x + 97, this.y + 112, 0x404040);
            this.field_146289_q.func_78276_b(String.format("\u041c\u0438\u0440: %s", this.selectedEntry.dimName), this.x + 97, this.y + 122, 0x404040);
            this.field_146289_q.func_78276_b(String.format("\u041c\u0438\u0440 ID: %d", this.selectedEntry.dimID), this.x + 97, this.y + 132, 0x404040);
            this.field_146289_q.func_78276_b(String.format("\u0422\u0438\u043f: %s", this.selectedEntry.sourceType), this.x + 97, this.y + 142, 0x404040);
            if (this.selectedEntry.sourceEntity != null) {
                this.field_146289_q.func_78276_b(String.format("\u0423\u0431\u0438\u0439\u0446\u0430: %s", this.selectedEntry.sourceEntity), this.x + 97, this.y + 152, 0x404040);
            }
        }
        this.field_146289_q.func_78276_b("\u0416\u0443\u0440\u043d\u0430\u043b \u0441\u043c\u0435\u0440\u0442\u0435\u0439 \u0438\u0433\u0440\u043e\u043a\u043e\u0432", this.x + 18, this.y + 7, 0x202020);
        this.field_146289_q.func_78276_b(this.adminData.watchedUsername, this.x + 18, this.y + 18, 0x202020);
        GL11.glDisable((int)3042);
    }

    private boolean isCalendarSpecialDay(LocalDate localDate) {
        return this.monthEntries.containsKey(localDate);
    }

    private void onCalendarDaySelected(LocalDate localDate) {
        if (!localDate.equals(this.calendar.getSelectedDay())) {
            this.deathList.clearVariants();
            this.deathList.resetSelection();
            List<InventoryHistoryEntry> entries = this.monthEntries.get(localDate);
            if (entries != null) {
                for (InventoryHistoryEntry entry : entries) {
                    this.deathList.addVariant(String.format("%02d\u0447 %02d\u043c %02d\u0441", entry.timestamp.getHour(), entry.timestamp.getMinute(), entry.timestamp.getSecond()));
                }
            }
        }
    }

    private void onCalendarButtonCallback(int buttonID) {
        if (this.packetCooldown.isOver(5L)) {
            this.packetCooldown.setZero();
            if (buttonID == -1 && this.calendar.getDisplayDate().isAfter((YearMonth)this.monthBoundaries.getKey())) {
                this.calendar.setDisplayDate(this.calendar.getDisplayDate().minusMonths(1L));
            } else if (buttonID == 1 && this.calendar.getDisplayDate().isBefore((YearMonth)this.monthBoundaries.getValue())) {
                this.calendar.setDisplayDate(this.calendar.getDisplayDate().plusMonths(1L));
            } else {
                return;
            }
            this.calendarTitle = this.calendar.getDisplayDate().getMonth().getDisplayName(this.localeTextstyle, this.locale);
            this.calendar.setSelectedDay(null);
            this.deathList.clearVariants();
            this.deathList.resetSelection();
            this.selectedEntry = null;
            this.openHistory.setEnabled(false);
            Ulysses.NETWORK.sendToServer((IMessage)PacketInventoryHistory_Request.retrieveDeathRecords(this.calendar.getDisplayDate()));
        }
    }

    private void onOpenHistory(int buttonID) {
        if (this.selectedEntry != null) {
            Ulysses.NETWORK.sendToServer((IMessage)PacketInventoryHistory_Request.exploreTimestamp(this.selectedEntry.timestamp));
        } else {
            this.openHistory.setEnabled(false);
        }
    }

    private void onTimestampSelected(int entry) {
        List<InventoryHistoryEntry> entries;
        if (this.calendar.getSelectedDay() != null && (entries = this.monthEntries.get(this.calendar.getSelectedDay())) != null && entries.size() > entry) {
            this.selectedEntry = entries.get(entry);
            this.openHistory.setEnabled(this.selectedEntry != null);
        }
    }
}

