/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.ulysses.common.integration;

import by.fxg.ulysses.common.integration.IntegrationPart;
import by.fxg.ulysses.common.integration.armourersWorkshop.IntegrationArmourersWorkshop;
import by.fxg.ulysses.common.integration.baubles.IntegrationBaubles;
import by.fxg.ulysses.common.integration.tconstruct.IntegrationTinkerConstruct;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.HashMap;
import java.util.Map;

public class IntegrationManager {
    public static final IntegrationManager INSTANCE = new IntegrationManager();
    private Map<String, IntegrationPart> integrationMap = new HashMap<String, IntegrationPart>();

    public void registerDefaultIntegrations() {
        this.registerIntegration(new IntegrationArmourersWorkshop());
        this.registerIntegration(new IntegrationBaubles());
        this.registerIntegration(new IntegrationTinkerConstruct());
    }

    public void init() {
        this.integrationMap.forEach((name, part) -> {
            if (part.isAvailable()) {
                if (FMLCommonHandler.instance().getSide().isClient()) {
                    part.onClientInit();
                } else {
                    part.onServerInit();
                }
            }
        });
    }

    public boolean registerIntegration(IntegrationPart part) {
        if (!this.integrationMap.containsKey(part.getModID())) {
            this.integrationMap.put(part.getModID(), part);
            return true;
        }
        return false;
    }

    public IntegrationPart getIntegrationByID(String modID) {
        return this.integrationMap.get(modID);
    }

    public Map<String, IntegrationPart> getIntegrations() {
        return this.integrationMap;
    }
}

