/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.ulysses.common.network;

import by.fxg.basicfml.network.SidedMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.time.LocalDateTime;
import java.time.YearMonth;

public class PacketInventoryHistory_Request
implements IMessage {
    protected Type type;
    protected YearMonth yearMonth;
    protected LocalDateTime timestamp;

    public static PacketInventoryHistory_Request retrieveDeathRecords(YearMonth yearMonth) {
        PacketInventoryHistory_Request packet = new PacketInventoryHistory_Request();
        packet.type = Type.RETRIEVE_DEATH_RECORDS;
        packet.yearMonth = yearMonth;
        return packet;
    }

    public static PacketInventoryHistory_Request exploreTimestamp(LocalDateTime timestamp) {
        PacketInventoryHistory_Request packet = new PacketInventoryHistory_Request();
        packet.type = Type.EXPLORE_TIMESTAMP;
        packet.timestamp = timestamp;
        return packet;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        switch (this.type) {
            case RETRIEVE_DEATH_RECORDS: {
                buf.writeShort(this.yearMonth.getYear());
                buf.writeByte(this.yearMonth.getMonthValue());
                break;
            }
            case EXPLORE_TIMESTAMP: {
                buf.writeShort(this.timestamp.getYear());
                buf.writeByte(this.timestamp.getMonthValue());
                buf.writeByte(this.timestamp.getDayOfMonth());
                buf.writeByte(this.timestamp.getHour());
                buf.writeByte(this.timestamp.getMinute());
                buf.writeByte(this.timestamp.getSecond());
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.type = Type.fromOrdinal(buf.readByte());
        switch (this.type) {
            case RETRIEVE_DEATH_RECORDS: {
                this.yearMonth = YearMonth.of((int)buf.readShort(), buf.readByte());
                break;
            }
            case EXPLORE_TIMESTAMP: {
                this.timestamp = LocalDateTime.of((int)buf.readShort(), buf.readByte(), (int)buf.readByte(), (int)buf.readByte(), (int)buf.readByte(), (int)buf.readByte());
            }
        }
    }

    public static enum Type {
        RETRIEVE_DEATH_RECORDS,
        EXPLORE_TIMESTAMP;

        private static final Type[] values;

        public static Type fromOrdinal(int ordinal) {
            return values[Math.max(0, Math.min(ordinal, values.length))];
        }

        static {
            values = Type.values();
        }
    }

    public static class Handler
    implements SidedMessageHandler<PacketInventoryHistory_Request, IMessage> {
    }
}

