/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.recipe.advanced;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import wanion.lib.recipe.advanced.IAdvancedRecipe;

public abstract class AbstractRecipeRegistry<R extends IAdvancedRecipe> {
    public final TLongObjectMap<List<R>> shapedRecipes = new TLongObjectHashMap();
    public final TIntObjectMap<List<R>> shapelessRecipes = new TIntObjectHashMap();

    public final void addRecipe(@Nonnull R recipe) {
        long recipeKey = recipe.getRecipeKey();
        if (recipeKey != 0L) {
            if (!this.shapedRecipes.containsKey(recipeKey)) {
                this.shapedRecipes.put(recipeKey, new ArrayList());
            }
            ((List)this.shapedRecipes.get(recipeKey)).add(recipe);
        } else {
            int recipeSize = recipe.getRecipeSize();
            if (!this.shapelessRecipes.containsKey(recipeSize)) {
                this.shapelessRecipes.put(recipeSize, new ArrayList());
            }
            ((List)this.shapelessRecipes.get(recipeSize)).add(recipe);
        }
    }

    public final void removeRecipe(@Nullable R recipe) {
        if (recipe == null) {
            return;
        }
        long recipeKey = recipe.getRecipeKey();
        if (recipeKey != 0L) {
            List shapedRecipeList = (List)this.shapedRecipes.get(recipeKey);
            if (shapedRecipeList != null) {
                shapedRecipeList.remove(recipe);
            }
        } else {
            List shapelessRecipeList = (List)this.shapelessRecipes.get(recipe.getRecipeSize());
            if (shapelessRecipeList != null) {
                shapelessRecipeList.remove(recipe);
            }
        }
    }

    public final ItemStack findMatchingRecipe(InventoryCrafting matrix) {
        ItemStack output;
        block13: {
            IAdvancedRecipe shapelessRecipe;
            List shapelessRecipeList;
            int actualX;
            int x;
            int y;
            int root = (int)Math.sqrt(matrix.func_70302_i_());
            int offSetX = 0;
            int offSetY = 0;
            int width = 0;
            int height = 0;
            int recipeSize = 0;
            long recipeKey = 0L;
            boolean foundX = false;
            boolean foundY = false;
            for (int x2 = 0; !foundX && x2 < root; ++x2) {
                for (int y2 = 0; !foundX && y2 < root; ++y2) {
                    if (matrix.func_70301_a(y2 * root + x2) == null) continue;
                    foundX = true;
                }
                if (!foundX) continue;
                offSetX = x2;
            }
            for (y = 0; !foundY && y < root; ++y) {
                for (x = 0; x < root; ++x) {
                    if (matrix.func_70301_a(y * root + x) != null) {
                        foundY = true;
                    }
                    if (!foundY) continue;
                    offSetY = y;
                }
            }
            for (y = 0; y < root; ++y) {
                int actualY;
                x = 0;
                while ((actualY = offSetY + y) < root && (actualX = offSetX + x++) < root && matrix.func_70301_a(actualY * root + actualX) != null) {
                    int xDifference = actualX - (offSetX - 1);
                    int yDifference = actualY - (offSetY - 1);
                    if (xDifference > width) {
                        width = xDifference;
                    }
                    if (yDifference <= height) continue;
                    height = yDifference;
                }
            }
            for (y = 0; y < height; ++y) {
                int actualY = offSetY + y;
                for (int x3 = 0; x3 < width; ++x3) {
                    actualX = offSetX + x3;
                    if (matrix.func_70301_a(actualY * root + actualX) == null) continue;
                    recipeKey |= (long)(1 << y * root + x3);
                    ++recipeSize;
                }
            }
            output = null;
            List shapedRecipeList = (List)this.shapedRecipes.get(recipeKey);
            if (shapedRecipeList != null) {
                IAdvancedRecipe shapedRecipe;
                Iterator x3 = shapedRecipeList.iterator();
                while (x3.hasNext() && (output = (shapedRecipe = (IAdvancedRecipe)x3.next()).recipeMatch(matrix, offSetX, offSetY)) == null) {
                }
            }
            if (output != null || (shapelessRecipeList = (List)this.shapelessRecipes.get(recipeSize)) == null) break block13;
            Iterator iterator = shapelessRecipeList.iterator();
            while (iterator.hasNext() && (output = (shapelessRecipe = (IAdvancedRecipe)iterator.next()).recipeMatch(matrix, offSetX, offSetY)) == null) {
            }
        }
        return output;
    }
}

