/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.pixelmon;

import cpw.mods.fml.common.Loader;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AddonPixelmonEntities
implements IWailaEntityProvider {
    public static Class classEntityPixelmon = null;
    public static Class enumNature = null;
    public static Class enumGrowth = null;
    private static final String CONFIG_REQUIRE_SNEAK = "wawla.pixelmon.useSneak";
    private static final String CONFIG_ABILITIES = "wawla.pixelmon.showAbility";
    private static final String CONFIG_FRIENDSHIP = "wawla.pixelmon.showFriendship";
    private static final String CONFIG_HELD_ITEM = "wawla.pixelmon.showHeldItem";
    private static final String CONFIG_NATURE = "wawla.pixelmon.showNature";
    private static final String CONFIG_SIZE = "wawla.pixelmon.showSize";
    private static final String CONFIG_INDIVIDUAL_VALUES = "wawla.pixelmon.showIV";
    private static final String CONFIG_EFFORT_VALUES = "wawla.pixelmon.showEV";
    private static String[] natureList = null;
    private static String[] sizeList = null;

    public AddonPixelmonEntities() {
        if (Loader.isModLoaded((String)"pixelmon")) {
            try {
                classEntityPixelmon = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon");
                enumNature = Class.forName("com.pixelmonmod.pixelmon.enums.EnumNature");
                enumGrowth = Class.forName("com.pixelmonmod.pixelmon.enums.EnumGrowth");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public Entity getWailaOverride(IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return data.getEntity();
    }

    public List<String> getWailaHead(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        boolean canDisplay;
        boolean bl = canDisplay = cfg.getConfig(CONFIG_REQUIRE_SNEAK) ? data.getPlayer().func_70093_af() : true;
        if (canDisplay && Utilities.compareByClass(classEntityPixelmon, entity.getClass()) && data.getNBTData() != null) {
            NBTTagCompound tag = data.getNBTData();
            if (natureList != null && cfg.getConfig(CONFIG_NATURE)) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.pixelmon.nature") + ": " + natureList[tag.func_74765_d("Nature")]);
            }
            if (cfg.getConfig(CONFIG_ABILITIES)) {
                EnumChatFormatting abilityColor = tag.func_74762_e("AbilitySlot") == 2 ? EnumChatFormatting.GOLD : EnumChatFormatting.GRAY;
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.pixelmon.ability") + ": " + abilityColor + tag.func_74779_i("Ability"));
            }
            if (sizeList != null && cfg.getConfig(CONFIG_SIZE)) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.pixelmon.size") + ": " + sizeList[tag.func_74765_d("Growth")]);
            }
            if (cfg.getConfig(CONFIG_FRIENDSHIP)) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.pixelmon.happiness") + ": " + tag.func_74762_e("Friendship"));
            }
            if (cfg.getConfig(CONFIG_HELD_ITEM) && tag.func_74764_b("HeldItemStack")) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.pixelmon.helditem") + ": " + ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)tag.func_74781_a("HeldItemStack"))).func_82833_r());
            }
            if (cfg.getConfig(CONFIG_INDIVIDUAL_VALUES)) {
                tip.add("IV's - Atk:" + tag.func_74762_e("IVAttack") + " Def:" + tag.func_74762_e("IVDefence") + " HP:" + tag.func_74762_e("IVHP") + " SpAtk: " + tag.func_74762_e("IVSpAtt") + " SpDef:" + tag.func_74762_e("IVSpDef") + " Spd:" + tag.func_74762_e("IVSpeed"));
            }
            if (cfg.getConfig(CONFIG_EFFORT_VALUES) && !tag.func_74779_i("OwnerUUID").isEmpty()) {
                tip.add("EV's - Atk:" + tag.func_74762_e("EVAttack") + " Def:" + tag.func_74762_e("EVDefence") + " HP:" + tag.func_74762_e("EVHP") + " SpAtk: " + tag.func_74762_e("EVSpAtt") + " SpDef:" + tag.func_74762_e("EVSpDef") + " Spd:" + tag.func_74762_e("EVSpeed"));
            }
        }
        return tip;
    }

    public List<String> getWailaTail(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity entity, NBTTagCompound tag, World world) {
        if (entity != null) {
            entity.func_70109_d(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonPixelmonEntities dataProvider = new AddonPixelmonEntities();
        register.addConfig("Pixelmon", CONFIG_REQUIRE_SNEAK);
        register.addConfig("Pixelmon", CONFIG_ABILITIES);
        register.addConfig("Pixelmon", CONFIG_FRIENDSHIP);
        register.addConfig("Pixelmon", CONFIG_HELD_ITEM);
        register.addConfig("Pixelmon", CONFIG_NATURE);
        register.addConfig("Pixelmon", CONFIG_SIZE);
        register.addConfig("Pixelmon", CONFIG_INDIVIDUAL_VALUES);
        register.addConfig("Pixelmon", CONFIG_EFFORT_VALUES);
        register.registerBodyProvider((IWailaEntityProvider)dataProvider, classEntityPixelmon);
        natureList = Utilities.generateElementArray(enumNature);
        sizeList = Utilities.generateElementArray(enumGrowth);
    }
}

