/*
 * Decompiled with CFR 0.152.
 */
package witchinggadgets.common.mob;

import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import witchinggadgets.common.mob.EntityAIWeaponAttack;

public class EntityScarecrow
extends EntityGolem
implements IEntitySelector {
    public static final ResourceLocation TEXTURE = new ResourceLocation("witchinggadgets:textures/entity/scarecrow.png");
    public int scarecrowAttackTime = 0;
    public byte sinks = (byte)-1;

    public boolean spawn(World world) {
        return world.func_72838_d((Entity)this);
    }

    public EntityScarecrow(World world) {
        super(world);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWeaponAttack(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, IMob.class, 0, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)"");
    }

    public String getCreator() {
        return this.field_70180_af.func_75681_e(17);
    }

    public void setCreator(String username) {
        if (!this.getCreator().equals(username)) {
            this.field_70180_af.func_75692_b(17, (Object)(username == null ? "" : username));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public boolean func_70650_aV() {
        return true;
    }

    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    public void func_70071_h_() {
        this.scarecrowAttackTime = Math.max(this.scarecrowAttackTime - 1, 0);
        super.func_70071_h_();
    }

    public ItemStack func_70694_bm() {
        return super.func_70694_bm();
    }

    public boolean func_70652_k(Entity entity) {
        boolean hit;
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (entity instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (hit = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage)) {
            if (knockback > 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if (entity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entity);
        }
        return hit;
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70621_aR() {
        return null;
    }

    protected String func_70673_aS() {
        return null;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        this.dropFewItems(recentlyHit, looting, 0.0f);
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (!this.canInteract(player)) {
            return super.func_70085_c(player);
        }
        ItemStack playerHeld = player.func_71124_b(0);
        if (playerHeld == null && this.func_71124_b(0) == null) {
            return super.func_70085_c(player);
        }
        if (playerHeld == null) {
            this.setEquipment(0, null);
        } else {
            if (player.func_70093_af()) {
                return super.func_70085_c(player);
            }
            ItemStack heldItem = this.func_71124_b(0);
            if (!this.field_70170_p.field_72995_K) {
                ItemStack split = playerHeld.func_77946_l();
                split.field_77994_a = 1;
                this.setEquipment(0, split);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --playerHeld.field_77994_a;
            }
            if (playerHeld.field_77994_a <= 0) {
                player.func_70062_b(0, null);
            }
        }
        return true;
    }

    public boolean canInteract(EntityPlayer player) {
        return this.func_70089_S() && player.func_70005_c_() == this.getCreator();
    }

    public boolean setEquipment(ItemStack itemStack) {
        if (itemStack != null) {
            for (int slot = 0; slot < 5; ++slot) {
                if (this.func_71124_b(slot) == null) continue;
                return this.setEquipment(slot, itemStack);
            }
            return false;
        }
        int slot = 0;
        if (itemStack.func_77973_b() instanceof ItemArmor) {
            slot = 4 - ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        }
        return this.setEquipment(slot, itemStack);
    }

    public boolean setEquipment(int slot, ItemStack itemStack) {
        if (!this.field_70170_p.field_72995_K && this.func_71124_b(slot) != null) {
            this.func_70099_a(this.func_71124_b(slot), 0.0f);
        }
        this.func_70062_b(slot, itemStack);
        this.field_82174_bp[slot] = 2.0f;
        return true;
    }

    public void doRangedAttack(EntityLivingBase target) {
        ItemStack held = this.func_71124_b(0);
        if (held == null) {
            return;
        }
        if (held.func_77973_b() instanceof ItemBow) {
            EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, 1.6f, 12.0f);
            this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)held);
            int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)held);
            if (power > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
            }
            if (punch > 0) {
                arrow.func_70240_a(punch);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)held) > 0) {
                arrow.func_70015_d(100);
            }
            this.field_70170_p.func_72838_d((Entity)arrow);
        } else {
            EntitySnowball snowball = new EntitySnowball(this.field_70170_p, (EntityLivingBase)this);
            double motionX = target.field_70165_t - this.field_70165_t;
            double motionY = target.field_70163_u + (double)target.func_70047_e() - 1.1 - snowball.field_70163_u;
            double motionZ = target.field_70161_v - this.field_70161_v;
            float velocity = (float)Math.sqrt(motionX * motionX + motionZ * motionZ) * 0.2f;
            snowball.func_70186_c(motionX, motionY + (double)velocity, motionZ, 1.6f, 12.0f);
            this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)snowball);
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        return super.func_70097_a(damageSource, damage);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.func_70062_b(4, new ItemStack(Blocks.field_150423_aK));
        this.field_82174_bp[4] = 0.0f;
        return data;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected Item func_146068_u() {
        return Item.func_150898_a((Block)Blocks.field_150325_L);
    }

    protected void dropFewItems(boolean recentlyHit, int looting, float dropChance) {
        int i = this.field_70146_Z.nextInt(3);
        while (i-- > 0) {
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150422_aJ), 1);
        }
        if (this.field_70146_Z.nextInt(2) == 0) {
            this.func_145779_a(this.func_146068_u(), 1);
        }
    }

    public boolean func_82704_a(Entity entity) {
        if (entity instanceof EntityPlayer && entity.func_70005_c_() == this.getCreator()) {
            return false;
        }
        return entity instanceof IMob;
    }
}

