/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.companions.renderers.renderhooks;

import com.InfinityRaider.companions.reference.Data;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class PlayerEffectRenderer {
    private static int instanceCounter = 0;
    private final String name;
    private final int id = instanceCounter++;

    PlayerEffectRenderer() {
        this.name = "companions.title_" + Data.titles[this.getId()];
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.getName().substring(this.getName().indexOf(95) + 1);
    }

    public float getVerticalOffset(EntityPlayer player) {
        if (player == Minecraft.func_71410_x().field_71439_g) {
            return 0.15f;
        }
        return player.func_70093_af() ? -0.35f : -0.5f;
    }

    abstract void renderEffects(EntityPlayer var1, RenderPlayer var2, float var3);

    protected void translateToGeneralCoordinates(EntityPlayer player, float partialTick) {
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTick;
        double y = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTick;
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTick;
        GL11.glTranslated((double)(-x), (double)(-y), (double)(-z));
    }

    protected void rotateToGeneralCoordinates(EntityPlayer player, float partialTick) {
        float yaw = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTick;
        GL11.glRotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    protected void drawAxisSystem() {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)-0.005f, 2.0, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)0.005f, 2.0, 0.0, 0.0, 0.0);
        tessellator.func_78374_a((double)0.005f, -1.0, 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)-0.005f, -1.0, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(2.0, (double)-0.005f, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(2.0, (double)0.005f, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(-1.0, (double)0.005f, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(-1.0, (double)-0.005f, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(0.0, (double)-0.005f, 2.0, 1.0, 0.0);
        tessellator.func_78374_a(0.0, (double)0.005f, 2.0, 0.0, 0.0);
        tessellator.func_78374_a(0.0, (double)0.005f, -1.0, 0.0, 1.0);
        tessellator.func_78374_a(0.0, (double)-0.005f, -1.0, 1.0, 1.0);
        tessellator.func_78381_a();
    }
}

