/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.companions.renderers.renderhooks;

import com.InfinityRaider.companions.renderers.renderhooks.PlayerEffectRenderer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class PlayerEffectRendererTrail
extends PlayerEffectRenderer {
    private ArrayList<int[]> trail = new ArrayList();
    private int tickCounter = 0;
    private int idleTimer = 0;
    private final int updateInterval;
    private final int maxSize;

    protected PlayerEffectRendererTrail(int updateInterval, int maxSize) {
        this.updateInterval = updateInterval;
        this.maxSize = maxSize;
    }

    @Override
    void renderEffects(EntityPlayer player, RenderPlayer renderer, float partialTick) {
        GL11.glPushMatrix();
        this.updateTrail(player);
        this.rotateToGeneralCoordinates(player, partialTick);
        this.translateToGeneralCoordinates(player, partialTick);
        for (int i = 0; i < this.trail.size(); ++i) {
            int[] coords = this.trail.get(i);
            float dy = this.getVerticalOffset(player);
            GL11.glTranslatef((float)((float)coords[0] - 0.5f), (float)((float)coords[1] + dy), (float)((float)coords[2] - 0.5f));
            GL11.glPushMatrix();
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)i / (float)this.trail.size()));
            this.draw(Tessellator.field_78398_a);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3008);
            GL11.glPopMatrix();
            GL11.glTranslatef((float)((float)(-coords[0]) + 0.5f), (float)((float)(-coords[1]) - dy), (float)((float)(-coords[2]) + 0.5f));
        }
        GL11.glPopMatrix();
    }

    protected abstract void draw(Tessellator var1);

    private void updateTrail(EntityPlayer player) {
        this.tickCounter = (this.tickCounter + 1) % this.updateInterval;
        int maxIdleTime = this.maxSize;
        if (this.tickCounter != 0) {
            return;
        }
        int[] lastCoords = this.trail.size() == 0 ? null : this.trail.get(this.trail.size() - 1);
        int[] current = new int[]{(int)player.field_70165_t, (int)player.field_70163_u - 1, (int)player.field_70161_v};
        if (this.isOnGround(player) && (lastCoords == null || current[0] != lastCoords[0] || current[1] != lastCoords[1] || current[2] != lastCoords[2])) {
            this.trail.add(current);
            this.idleTimer = 0;
        } else {
            this.idleTimer = this.trail.size() == 0 ? 0 : (this.idleTimer += this.idleTimer >= maxIdleTime ? 0 : 1);
        }
        if (this.idleTimer >= maxIdleTime || this.trail.size() > this.maxSize) {
            // empty if block
        }
    }

    private boolean isOnGround(EntityPlayer player) {
        if (player == Minecraft.func_71410_x().field_71439_g) {
            return player.field_70122_E;
        }
        return !player.field_70170_p.func_147437_c((int)player.field_70165_t, (int)player.field_70163_u - 1, (int)player.field_70161_v);
    }
}

