/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.companions.renderers.renderhooks;

import com.InfinityRaider.companions.handler.ConfigurationHandler;
import com.InfinityRaider.companions.renderers.renderhooks.PlayerEffectRenderer;
import com.InfinityRaider.companions.renderers.renderhooks.PlayerEffectRendererButterfly;
import com.InfinityRaider.companions.renderers.renderhooks.PlayerEffectRendererEntityBat;
import com.InfinityRaider.companions.renderers.renderhooks.PlayerEffectRendererEntityDragon;
import com.InfinityRaider.companions.renderers.renderhooks.PlayerEffectRendererNavi;
import com.InfinityRaider.companions.renderers.renderhooks.PlayerEffectRendererParticlesEnchanted;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderPlayerEvent;
import travellersgear.api.TravellersGearAPI;

@SideOnly(value=Side.CLIENT)
public final class RenderPlayerHooks {
    private HashMap<Integer, PlayerEffectRenderer> renderers;
    private HashMap<String, Integer> ids;
    private static boolean hasInit = false;

    public RenderPlayerHooks() {
        if (!hasInit) {
            hasInit = true;
            this.renderers = new HashMap();
            this.ids = new HashMap();
            this.init();
        }
    }

    private void init() {
        this.registerPlayerEffectRenderer(new PlayerEffectRendererNavi());
        this.registerPlayerEffectRenderer(new PlayerEffectRendererParticlesEnchanted());
        this.registerPlayerEffectRenderer(new PlayerEffectRendererEntityDragon());
        this.registerPlayerEffectRenderer(new PlayerEffectRendererEntityBat());
        this.registerPlayerEffectRenderer(new PlayerEffectRendererButterfly());
    }

    private void registerPlayerEffectRenderer(PlayerEffectRenderer renderer) {
        if (ConfigurationHandler.disableRenderEffect(renderer.getSimpleName())) {
            return;
        }
        this.renderers.put(renderer.getId(), renderer);
        this.ids.put(renderer.getName(), renderer.getId());
    }

    private PlayerEffectRenderer getRendererFromId(int id) {
        return this.renderers.get(id);
    }

    private PlayerEffectRenderer getRendererFromTitle(String title) {
        try {
            return this.getRendererFromId(this.ids.get(title));
        }
        catch (Exception e) {
            return null;
        }
    }

    @SubscribeEvent
    public void RenderPlayerEffects(RenderPlayerEvent.Specials.Post event) {
        String title;
        ItemStack titleStack = TravellersGearAPI.getExtendedInventory((EntityPlayer)event.entityPlayer)[3];
        if (titleStack == null || titleStack.func_77973_b() == null) {
            return;
        }
        String string = title = titleStack.func_77942_o() && titleStack.field_77990_d.func_74764_b("title") ? titleStack.field_77990_d.func_74779_i("title") : null;
        if (title == null) {
            return;
        }
        PlayerEffectRenderer renderer = this.getRendererFromTitle(title);
        if (renderer == null) {
            return;
        }
        renderer.renderEffects(event.entityPlayer, event.renderer, event.partialRenderTick);
    }
}

