/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.companions.utility;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public abstract class RenderHelper {
    public static ResourceLocation getResource(Block block, int meta) {
        return RenderHelper.getBlockResource(RenderHelper.getIcon(block, meta));
    }

    public static ResourceLocation getResource(Item item, int meta) {
        return RenderHelper.getItemResource(RenderHelper.getIcon(item, meta));
    }

    public static IIcon getIcon(Item item, int meta) {
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a.func_149691_a(3, meta);
        }
        return item.func_77617_a(meta);
    }

    public static IIcon getIcon(Block block, int meta) {
        return block.func_149691_a(0, meta);
    }

    public static ResourceLocation getBlockResource(IIcon icon) {
        if (icon == null) {
            return null;
        }
        String path = icon.func_94215_i();
        String domain = path.substring(0, path.indexOf(":") + 1);
        String file = path.substring(path.indexOf(58) + 1);
        return new ResourceLocation(domain + "textures/blocks/" + file + ".png");
    }

    public static ResourceLocation getItemResource(IIcon icon) {
        if (icon == null) {
            return null;
        }
        String path = icon.func_94215_i();
        String domain = path.substring(0, path.indexOf(":") + 1);
        String file = path.substring(path.indexOf(58) + 1);
        return new ResourceLocation(domain + "textures/items/" + file + ".png");
    }

    public static boolean isLeverFacingBlock(int leverMeta, char axis, int direction) {
        if (axis == 'x') {
            if (direction > 0) {
                return leverMeta % 8 == 1;
            }
            return leverMeta % 8 == 2;
        }
        if (axis == 'z') {
            if (direction > 0) {
                return leverMeta % 8 == 3;
            }
            return leverMeta % 8 == 4;
        }
        return false;
    }

    public static void addScaledVertexWithUV(Tessellator tessellator, float x, float y, float z, float u, float v) {
        float unit = 0.0625f;
        tessellator.func_78374_a((double)(x * unit), (double)(y * unit), (double)(z * unit), (double)(u * unit), (double)(v * unit));
    }

    public static void addScaledVertexWithUV(Tessellator tessellator, float x, float y, float z, float u, float v, IIcon icon) {
        float unit = 0.0625f;
        tessellator.func_78374_a((double)(x * unit), (double)(y * unit), (double)(z * unit), (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
    }
}

