/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.asm;

import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class SafeCore
implements IClassTransformer {
    private static Side INVALID_SIDE = FMLLaunchHandler.side() == Side.CLIENT ? Side.SERVER : Side.CLIENT;
    private static String SIDE_SERVER = Side.SERVER.name();
    private static String SIDE_CLIENT = Side.CLIENT.name();
    private static HashMap<String, Side> classSideHashMap = new HashMap();
    LaunchClassLoader cl = (LaunchClassLoader)SafeCore.class.getClassLoader();
    public String[] clientPrefixes = new String[]{"net.minecraft.", "net.minecraftforge.", "cpw.mods.fml", "com.rwtema.extrautils."};

    public Side getSide(String clazz) {
        if (classSideHashMap.containsKey(clazz)) {
            return classSideHashMap.get(clazz);
        }
        Side side = this.getSide_do(clazz);
        classSideHashMap.put(clazz, side);
        return side;
    }

    public Side getSide_do(String clazz) {
        byte[] bytes;
        if (clazz.indexOf(46) == -1) {
            return null;
        }
        try {
            bytes = this.cl.getClassBytes(clazz);
        }
        catch (IOException e) {
            return INVALID_SIDE;
        }
        if (bytes == null) {
            return INVALID_SIDE;
        }
        boolean flag = true;
        for (String clientPrefix : this.clientPrefixes) {
            if (!clazz.startsWith(clientPrefix)) continue;
            flag = false;
            break;
        }
        if (flag) {
            return null;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return this.getSide(classNode.visibleAnnotations);
    }

    public Side getSide(List<AnnotationNode> anns) {
        if (anns == null) {
            return null;
        }
        for (AnnotationNode ann : anns) {
            if (!ann.desc.equals(Type.getDescriptor(SideOnly.class)) || ann.values == null) continue;
            for (int x = 0; x < ann.values.size() - 1; x += 2) {
                Object key = ann.values.get(x);
                Object value = ann.values.get(x + 1);
                if (!(key instanceof String) || !key.equals("value") || !(value instanceof String[])) continue;
                String s = ((String[])value)[1];
                if (s.equals(SIDE_SERVER)) {
                    return Side.SERVER;
                }
                if (!s.equals(SIDE_CLIENT)) continue;
                return Side.CLIENT;
            }
        }
        return null;
    }

    public boolean isInvalid(String clazz) {
        return this.getSide(clazz) == INVALID_SIDE;
    }

    public boolean isInvalid(Type type) {
        while (type.getSort() == 9) {
            type = type.getElementType();
        }
        return type.getSort() != 11 && this.isInvalid(type.getClassName());
    }

    public boolean isInvalid(Type[] types) {
        for (Type type : types) {
            if (!this.isInvalid(type)) continue;
            return true;
        }
        return false;
    }

    public byte[] transform(String s, String s2, byte[] bytes) {
        if (!s.startsWith("com.rwtema.extrautils")) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)classNode, 0);
        Side side = this.getSide(classNode.visibleAnnotations);
        classSideHashMap.put(s, side);
        this.stripInvalidAnnotations(classNode.visibleAnnotations);
        Iterator iterator = classNode.fields.iterator();
        while (iterator.hasNext()) {
            FieldNode field = (FieldNode)iterator.next();
            if (this.isInvalid(Type.getType((String)field.desc))) {
                iterator.remove();
                continue;
            }
            this.stripInvalidAnnotations(field.visibleAnnotations);
        }
        iterator = classNode.methods.iterator();
        while (iterator.hasNext()) {
            MethodNode method = (MethodNode)iterator.next();
            if (this.invalidMethod(method)) {
                iterator.remove();
                continue;
            }
            this.stripInvalidAnnotations(method.visibleAnnotations);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public void stripInvalidAnnotations(List<AnnotationNode> visibleAnnotations) {
        if (visibleAnnotations == null) {
            return;
        }
        Iterator<AnnotationNode> iterator = visibleAnnotations.iterator();
        while (iterator.hasNext()) {
            AnnotationNode visibleAnnotation = iterator.next();
            if (!this.isInvalid(Type.getType((String)visibleAnnotation.desc))) continue;
            iterator.remove();
        }
    }

    public boolean invalidMethod(MethodNode method) {
        if (this.isInvalid(Type.getReturnType((String)method.desc))) {
            return true;
        }
        for (Type type : Type.getArgumentTypes((String)method.desc)) {
            if (!this.isInvalid(type)) continue;
            return true;
        }
        return false;
    }

    static {
        classSideHashMap.put(Boolean.TYPE.getName(), null);
        classSideHashMap.put(Byte.TYPE.getName(), null);
        classSideHashMap.put(Character.TYPE.getName(), null);
        classSideHashMap.put(Double.TYPE.getName(), null);
        classSideHashMap.put(Float.TYPE.getName(), null);
        classSideHashMap.put(Integer.TYPE.getName(), null);
        classSideHashMap.put(Long.TYPE.getName(), null);
        classSideHashMap.put(Short.TYPE.getName(), null);
        classSideHashMap.put(Void.TYPE.getName(), null);
    }
}

