/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.gui;

import com.rwtema.extrautils.gui.ContainerFilingCabinet;
import com.rwtema.extrautils.gui.SlotFilingCabinet;
import com.rwtema.extrautils.tileentity.TileEntityFilingCabinet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiFilingCabinet
extends GuiContainer {
    private static final ResourceLocation texture = new ResourceLocation("extrautils", "textures/guiFilingCabinet.png");
    ItemSorter sorter = new ItemSorter();
    private int numItems = 0;
    private int currentScroll = 0;
    private boolean isScrolling = false;
    private int prevn;
    private final TileEntityFilingCabinet cabinet;
    private final ArrayList<Slot> itemsSorter = new ArrayList(108);
    private final ArrayList<Slot> itemsDisplay = new ArrayList(90);

    public GuiFilingCabinet(IInventory player, TileEntityFilingCabinet cabinet) {
        super((Container)new ContainerFilingCabinet(player, cabinet, true));
        this.field_146999_f = 176;
        this.field_147000_g = 240;
        this.cabinet = cabinet;
        this.prevn = cabinet.getMaxSlots();
        for (Slot slot : this.field_147002_h.field_75151_b) {
            if (slot.field_75224_c != player) continue;
            this.itemsDisplay.add(slot);
        }
    }

    public void sortItems() {
        int currentMax = this.cabinet.getMaxSlots();
        this.itemsSorter.clear();
        this.numItems = 0;
        for (int i = 0; i < currentMax; ++i) {
            if (((Slot)this.field_147002_h.field_75151_b.get(i)).func_75216_d()) {
                ++this.numItems;
            } else if (i > this.prevn) break;
            this.itemsSorter.add((Slot)this.field_147002_h.field_75151_b.get(i));
        }
        this.prevn = this.numItems + 1;
        this.itemsSorter.sort(this.sorter);
        int start = this.getStartSlot();
        if (start > this.numItems - 54) {
            start = this.numItems - 54;
        }
        if (start < 0) {
            start = 0;
        }
        int s = this.itemsSorter.size();
        for (int i = 0; i < s; ++i) {
            if (i >= start && i < start + 54) {
                int x = (i - start) % 9;
                int y = (i - start - x) / 9;
                Slot ss = this.itemsSorter.get(i);
                ss.field_75223_e = 8 + x * 18;
                ss.field_75221_f = 18 + y * 18;
                this.itemsDisplay.add(ss);
                continue;
            }
            Slot ss = this.itemsSorter.get(i);
            ss.field_75223_e = Integer.MIN_VALUE;
            ss.field_75221_f = Integer.MIN_VALUE;
        }
        this.itemsDisplay.removeIf(slot -> slot.field_75223_e == Integer.MIN_VALUE);
        ContainerFilingCabinet.updated = false;
    }

    private void updateVisibleSlots() {
        int start = this.getStartSlot();
        if (start > this.numItems - 54) {
            start = this.numItems - 54;
        }
        if (start < 0) {
            start = 0;
        }
        int s = this.itemsSorter.size();
        for (int i = 0; i < s; ++i) {
            if (i >= start && i < start + 54) {
                int x = (i - start) % 9;
                int y = (i - start - x) / 9;
                Slot ss = this.itemsSorter.get(i);
                ss.field_75223_e = 8 + x * 18;
                ss.field_75221_f = 18 + y * 18;
                this.itemsDisplay.add(ss);
                continue;
            }
            Slot ss = this.itemsSorter.get(i);
            ss.field_75223_e = Integer.MIN_VALUE;
            ss.field_75221_f = Integer.MIN_VALUE;
        }
        this.itemsDisplay.removeIf(slot -> slot.field_75223_e == Integer.MIN_VALUE);
    }

    private void scrollFast(int mX) {
        int prevScroll = this.getStartSlot();
        this.currentScroll = this.numItems <= 54 ? 0 : mX;
        if (prevScroll != this.getStartSlot()) {
            this.updateVisibleSlots();
        }
    }

    public int getStartSlot() {
        float t = this.currentScroll;
        return (int)Math.floor((double)(t /= 144.0f) * Math.ceil(this.numItems - 54 + 1));
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.numItems <= 54) {
            this.func_73729_b(k + this.ScrollX(), l + 128, 176, 9, 17, 8);
        } else {
            this.func_73729_b(k + this.ScrollX(), l + 128, 176, 0, 17, 8);
        }
    }

    public void setScroll(int mX) {
        int prevScroll = this.getStartSlot();
        this.currentScroll = this.numItems <= 54 ? 0 : mX;
        if (prevScroll != this.getStartSlot()) {
            this.sortItems();
        }
    }

    public int ScrollX() {
        return this.numItems <= 54 ? 8 : (this.currentScroll < 0 ? 8 : (this.currentScroll > 143 ? 151 : 8 + this.currentScroll));
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        if (par3 >= 0) {
            this.isScrolling = false;
        }
        super.func_146286_b(par1, par2, par3);
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        if (!this.isScrolling && par3 == 0 && this.func_146978_c(8, 128, 162, 8, par1, par2)) {
            this.isScrolling = true;
            this.scrollFast(par1 - this.field_147003_i - 8 - 9);
        }
        super.func_73864_a(par1, par2, par3);
    }

    protected void func_146273_a(int par1, int par2, int par3, long par4) {
        if (this.isScrolling) {
            this.scrollFast(par1 - this.field_147003_i - 8 - 9);
        }
        super.func_146273_a(par1, par2, par3, par4);
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.numItems > 54) {
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll -= i * 9;
            if (this.currentScroll < 0) {
                this.currentScroll = 0;
            }
            if (this.currentScroll > 153) {
                this.currentScroll = 153;
            }
            this.scrollFast(this.currentScroll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73863_a(int par1, int par2, float par3) {
        if (ContainerFilingCabinet.updated) {
            this.sortItems();
        }
        SlotFilingCabinet.drawing = true;
        List slotsBackup = this.field_147002_h.field_75151_b;
        try {
            this.field_147002_h.field_75151_b = this.itemsDisplay;
            super.func_73863_a(par1, par2, par3);
        }
        finally {
            this.field_147002_h.field_75151_b = slotsBackup;
        }
        SlotFilingCabinet.drawing = false;
    }

    public static class ItemSorter
    implements Comparator<Slot> {
        @Override
        public int compare(Slot arg0, Slot arg1) {
            ItemStack stack0 = arg0.func_75211_c();
            ItemStack stack1 = arg1.func_75211_c();
            if (stack0 == null) {
                return stack1 == null ? 0 : 1;
            }
            if (stack1 == null) {
                return -1;
            }
            int b = stack0.func_82833_r().compareTo(stack1.func_82833_r());
            if (b != 0) {
                return b;
            }
            int count = this.intCompare(stack0.func_77960_j(), stack1.func_77960_j());
            if (count != 0) {
                return count;
            }
            return this.intCompare(stack1.field_77994_a, stack0.field_77994_a);
        }

        public int intCompare(int a, int b) {
            return a == b ? 0 : (a > b ? 1 : -1);
        }

        public String concat(List list) {
            if (list.isEmpty()) {
                return "";
            }
            StringBuilder s = new StringBuilder();
            for (String aList : list) {
                s.append(aList).append("\n");
            }
            return s.toString();
        }
    }
}

