/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.multipart.microblock;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.MicroMaterialRegistry;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.ICreativeTabSorting;
import com.rwtema.extrautils.multipart.microblock.CreativeTabMicroBlocks;
import com.rwtema.extrautils.multipart.microblock.IMicroBlock;
import com.rwtema.extrautils.multipart.microblock.RegisterMicroBlocks;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import scala.Tuple2;
import team.luxinfine.extrautils.EventConfig;

public class ItemMicroBlock
extends Item
implements ICreativeTabSorting {
    public static ItemMicroBlock instance;

    public ItemMicroBlock() {
        instance = this;
        if (ExtraUtils.showMultiblocksTab) {
            this.func_77637_a(CreativeTabMicroBlocks.instance);
        }
        this.func_77655_b("extrautils:microblocks");
        this.func_77627_a(true);
    }

    public static ItemStack getStack(ItemStack item, String material) {
        item = item.func_77946_l();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("mat", material);
        item.func_77982_d(tag);
        return item;
    }

    public String func_77653_i(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return "ERR";
        }
        String material = stack.func_77978_p().func_74779_i("mat");
        return MicroMaterialRegistry.getMaterial((String)material) == null ? "ERR" : MicroMaterialRegistry.getMaterial((String)material).getLocalizedName() + " " + super.func_77653_i(stack);
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return super.func_77658_a() + "." + par1ItemStack.func_77960_j();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (IMicroBlock microBlock : RegisterMicroBlocks.mParts.values()) {
            if (microBlock.hideCreativeTab()) continue;
            int meta = microBlock.getMetadata();
            ItemStack item = new ItemStack(par1, 1, meta);
            if (EventConfig.hideMicroblocks) {
                par3List.add(ItemMicroBlock.getStack(item, Blocks.field_150348_b.delegate.name()));
                continue;
            }
            for (Tuple2 t : MicroMaterialRegistry.getIdMap()) {
                par3List.add(ItemMicroBlock.getStack(item, (String)t._1()));
            }
        }
    }

    public double getHitDepth(Vector3 vhit, int side) {
        return vhit.copy().scalarProject(Rotation.axes[side]) + (double)(side % 2 ^ 1);
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        BlockCoord pos = new BlockCoord(x, y, z);
        Vector3 vhit = new Vector3((double)hitX, (double)hitY, (double)hitZ);
        double d = this.getHitDepth(vhit, side);
        if (d < 1.0 && this.place(item, player, world, pos, side, vhit)) {
            return true;
        }
        pos.offset(side);
        return this.place(item, player, world, pos, side, vhit);
    }

    public boolean place(ItemStack stack, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 arg5) {
        TMultiPart part = this.newPart(stack, player, world, pos, side, arg5);
        if (part != null && TileMultipart.canPlacePart((World)world, (BlockCoord)pos, (TMultiPart)part)) {
            if (!world.field_72995_K) {
                TileMultipart.addPart((World)world, (BlockCoord)pos, (TMultiPart)part);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public TMultiPart newPart(ItemStack stack, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 arg5) {
        if (!stack.func_77942_o()) {
            return null;
        }
        String material = stack.func_77978_p().func_74779_i("mat");
        if (!material.equals("") && MicroMaterialRegistry.getMaterial((String)material) != null) {
            IMicroBlock part = RegisterMicroBlocks.mParts.get(stack.func_77960_j());
            return part != null ? part.placePart(stack, player, world, pos, side, arg5, MicroMaterialRegistry.materialID((String)material)) : null;
        }
        return null;
    }

    @Override
    public String getSortingName(ItemStack par1ItemStack) {
        return par1ItemStack.func_77977_a() + "_" + par1ItemStack.func_77960_j() + "_" + par1ItemStack.func_82833_r();
    }
}

