/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.network;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.ExtraUtilsMod;
import com.rwtema.extrautils.helper.XUHelper;
import com.rwtema.extrautils.item.scanner.ItemScanner;
import com.rwtema.extrautils.network.PacketCodec;
import com.rwtema.extrautils.network.XUPacketBase;
import com.rwtema.extrautils.network.packets.PacketParticle;
import com.rwtema.extrautils.network.packets.PacketParticleEvent;
import com.rwtema.extrautils.network.packets.PacketPlaySound;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class NetworkHandler {
    public static EnumMap<Side, FMLEmbeddedChannel> channels;

    public static void register() {
        channels = NetworkRegistry.INSTANCE.newChannel("XU|Pkt", new ChannelHandler[]{new PacketCodec(), ExtraUtilsMod.proxy.getNewPacketHandler()});
    }

    public static void checkPacket(XUPacketBase packet, Side properSenderSide) {
        if (!packet.isValidSenderSide(properSenderSide)) {
            throw new RuntimeException("Sending packet class" + packet.getClass().getSimpleName() + " from wrong side");
        }
    }

    public static void sendToAllPlayers(XUPacketBase packet) {
        NetworkHandler.checkPacket(packet, Side.SERVER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    public static void sendPacketToPlayer(XUPacketBase packet, EntityPlayer player) {
        NetworkHandler.checkPacket(packet, Side.SERVER);
        if (XUHelper.isPlayerFake(player)) {
            return;
        }
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    public static void sendToAllAround(XUPacketBase packet, int dimension, double x, double y, double z, double range) {
        NetworkHandler.sendToAllAround(packet, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static void sendToAllAround(XUPacketBase packet, NetworkRegistry.TargetPoint point) {
        NetworkHandler.checkPacket(packet, Side.SERVER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        channels.get(Side.SERVER).writeAndFlush((Object)packet).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendPacketToServer(XUPacketBase packet) {
        NetworkHandler.checkPacket(packet, Side.CLIENT);
        channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channels.get(Side.CLIENT).writeOutbound(new Object[]{packet});
    }

    public static void sendParticle(World world, String p, double x, double y, double z, double vx, double vy, double vz, boolean scannersOnly) {
        int maxDistance = 32;
        if (scannersOnly && ExtraUtils.scanner == null) {
            return;
        }
        PacketParticle packet = new PacketParticle(p, x, y, z, vx, vy, vz);
        if (scannersOnly && !ItemScanner.scannerOut) {
            return;
        }
        boolean noScanners = true;
        for (int j = 0; j < world.field_73010_i.size(); ++j) {
            EntityPlayerMP player = (EntityPlayerMP)world.field_73010_i.get(j);
            if (scannersOnly && (player.func_71045_bC() == null || player.func_71045_bC().func_77973_b() != ExtraUtils.scanner) || !(Math.abs(player.field_70165_t - x) <= (double)maxDistance) || !(Math.abs(player.field_70163_u - y) <= (double)maxDistance) || !(Math.abs(player.field_70161_v - z) <= (double)maxDistance)) continue;
            NetworkHandler.sendPacketToPlayer(packet, (EntityPlayer)player);
        }
    }

    public static void sendParticleEvent(World world, int type, int x, int y, int z) {
        int maxDistance = 24;
        if (type < 0) {
            return;
        }
        PacketParticleEvent packet = new PacketParticleEvent(x, y, z, (byte)type);
        NetworkHandler.sendToAllAround(packet, world.field_73011_w.field_76574_g, x, y, z, maxDistance);
    }

    public static void sendSoundEvent(World world, int type, float x, float y, float z) {
        int maxDistance = 32;
        if (type < 0) {
            return;
        }
        PacketPlaySound packet = new PacketPlaySound((short)type, x, y, z);
        NetworkHandler.sendToAllAround(packet, world.field_73011_w.field_76574_g, x, y, z, maxDistance);
    }

    public static void sendToAllAround(XUPacketBase packet, int chunkX, int chunkZ) {
        ChunkCoordIntPair chunkCoordIntPair = new ChunkCoordIntPair(chunkX, chunkZ);
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b) {
            if (!player.field_71129_f.contains(chunkCoordIntPair)) continue;
            NetworkHandler.sendPacketToPlayer(packet, (EntityPlayer)player);
        }
    }
}

