/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.World;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXBubble;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.Thaumcraft;

public class MultiTickEffectDispatcher {
    private static ReentrantLock renderLock = new ReentrantLock();
    private static List<VortexDigInfo> vortexDigInfos = new ArrayList<VortexDigInfo>();
    private static List<FloatyLineInfo> floatyLineInfos = new ArrayList<FloatyLineInfo>();
    private static List<BubbleFXInfo> bubbleInfos = new ArrayList<BubbleFXInfo>();

    public static void notifyRenderTick(World currentRenderWorld, float partialTicks) {
        renderLock.lock();
        try {
            MultiTickEffectDispatcher.handleVortexDiggingEffects(currentRenderWorld);
            MultiTickEffectDispatcher.handleWispyLineEffects(currentRenderWorld, partialTicks);
            MultiTickEffectDispatcher.handleBubbleSpawnings(currentRenderWorld);
        }
        finally {
            renderLock.unlock();
        }
    }

    private static void handleBubbleSpawnings(World world) {
        Iterator<BubbleFXInfo> it = bubbleInfos.iterator();
        while (it.hasNext()) {
            BubbleFXInfo info = it.next();
            if (info.dimId != world.field_73011_w.field_76574_g) {
                it.remove();
                continue;
            }
            info.renderTicks++;
            if (info.renderTicks > info.overallTicks) {
                it.remove();
                continue;
            }
            if (world.field_73012_v.nextInt(3) != 0) continue;
            float x = info.posX + (float)(world.field_73012_v.nextBoolean() ? 1 : -1) * (world.field_73012_v.nextFloat() * info.rangeAroundItem);
            float y = info.posY + (float)(world.field_73012_v.nextBoolean() ? 1 : -1) * (world.field_73012_v.nextFloat() * info.rangeAroundItem);
            float z = info.posZ + (float)(world.field_73012_v.nextBoolean() ? 1 : -1) * (world.field_73012_v.nextFloat() * info.rangeAroundItem);
            FXBubble fb = new FXBubble(world, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, 0);
            fb.func_82338_g(0.25f);
            fb.setRGB(1.0f, 1.0f, 1.0f);
            ParticleEngine.instance.addEffect(world, (EntityFX)fb);
        }
    }

    private static void handleWispyLineEffects(World currentRenderWorld, float partialTicks) {
        Iterator<FloatyLineInfo> it = floatyLineInfos.iterator();
        while (it.hasNext()) {
            FloatyLineInfo info = it.next();
            if (info.dimId != currentRenderWorld.field_73011_w.field_76574_g) {
                it.remove();
                continue;
            }
            info.renderTicks++;
            if (info.renderTicks > info.tickCap) {
                it.remove();
                continue;
            }
            if (info.randomOffset == -1) {
                info.randomOffset = currentRenderWorld.field_73012_v.nextInt(20);
            }
            float ticks = (float)(Minecraft.func_71410_x().field_71451_h.field_70173_aa + info.randomOffset) + partialTicks;
            UtilsFX.drawFloatyLine((double)info.pedestalX, (double)info.pedestalY, (double)info.pedestalZ, (double)info.originX, (double)info.originY, (double)info.originZ, (float)partialTicks, (int)info.colorAsInt, (String)"textures/misc/wispy.png", (float)-0.02f, (float)(Math.min(ticks, 10.0f) / 10.0f));
        }
    }

    private static void handleVortexDiggingEffects(World currentRenderWorld) {
        Iterator<VortexDigInfo> it = vortexDigInfos.iterator();
        while (it.hasNext()) {
            VortexDigInfo info = it.next();
            if (info.dimId != currentRenderWorld.field_73011_w.field_76574_g) {
                it.remove();
                continue;
            }
            info.renderTicks++;
            if (info.renderTicks > info.tickCap) {
                it.remove();
                continue;
            }
            Thaumcraft.proxy.boreDigFx(currentRenderWorld, info.tX, info.tY, info.tZ, info.oX, info.oY, info.oZ, info.blockInstance, info.meta);
        }
    }

    public static void registerBubbles(BubbleFXInfo info) {
        renderLock.lock();
        try {
            bubbleInfos.add(info);
        }
        finally {
            renderLock.unlock();
        }
    }

    public static void registerVortexDig(VortexDigInfo info) {
        renderLock.lock();
        try {
            vortexDigInfos.add(info);
        }
        finally {
            renderLock.unlock();
        }
    }

    public static void registerFloatyLine(FloatyLineInfo info) {
        renderLock.lock();
        try {
            floatyLineInfos.add(info);
        }
        finally {
            renderLock.unlock();
        }
    }

    public static class VortexDigInfo {
        private int dimId;
        private int oX;
        private int oY;
        private int oZ;
        private int tX;
        private int tY;
        private int tZ;
        private Block blockInstance;
        private int meta;
        private int renderTicks = 0;
        private int tickCap;

        public VortexDigInfo(int dimId, int oX, int oY, int oZ, int tX, int tY, int tZ, Block blockInstance, int meta, int tickDuration) {
            this.dimId = dimId;
            this.oX = oX;
            this.oY = oY;
            this.oZ = oZ;
            this.tX = tX;
            this.tY = tY;
            this.tZ = tZ;
            this.blockInstance = blockInstance;
            this.meta = meta;
            this.tickCap = tickDuration;
        }
    }

    public static class BubbleFXInfo {
        private int dimId;
        private float posX;
        private float posY;
        private float posZ;
        private int renderTicks;
        private int overallTicks;
        private float rangeAroundItem;

        public BubbleFXInfo(int dimId, float posX, float posY, float posZ, int overallTicks, float rangeAroundItem) {
            this.dimId = dimId;
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.overallTicks = overallTicks;
            this.rangeAroundItem = rangeAroundItem;
        }
    }

    public static class FloatyLineInfo {
        private int dimId;
        private double pedestalX;
        private double pedestalY;
        private double pedestalZ;
        private double originX;
        private double originY;
        private double originZ;
        private int renderTicks = 0;
        private int tickCap;
        private int colorAsInt;
        private int randomOffset = -1;

        public FloatyLineInfo(int dimId, double pedestalX, double pedestalY, double pedestalZ, double originX, double originY, double originZ, int tickCap, int colorAsInt) {
            this.dimId = dimId;
            this.pedestalX = pedestalX;
            this.pedestalY = pedestalY;
            this.pedestalZ = pedestalZ;
            this.originX = originX;
            this.originY = originY;
            this.originZ = originZ;
            this.tickCap = tickCap;
            this.colorAsInt = colorAsInt;
        }
    }
}

