/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import makeo.gadomancy.common.utils.NBTHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import thaumcraft.common.tiles.TileJarFillable;

public class TileRemoteJar
extends TileJarFillable {
    public UUID networkId = null;
    private int count = 0;
    private static Map<UUID, JarNetwork> networks = new HashMap<UUID, JarNetwork>();

    public void func_145845_h() {
        super.func_145845_h();
        if (this.count % 3 == 0 && !this.func_145831_w().field_72995_K && this.networkId != null && this.amount < this.maxAmount) {
            this.count = 0;
            JarNetwork network = TileRemoteJar.getNetwork(this.networkId);
            if (!network.jars.contains((Object)this)) {
                network.jars.add((TileJarFillable)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            }
            network.update();
        }
        ++this.count;
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.networkId = NBTHelper.getUUID(compound, "networkId");
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        if (this.networkId != null) {
            NBTHelper.setUUID(compound, "networkId", this.networkId);
        }
    }

    private static JarNetwork getNetwork(UUID id) {
        JarNetwork network = networks.get(id);
        if (network == null) {
            network = new JarNetwork();
            networks.put(id, network);
        }
        return network;
    }

    public void markForUpdate() {
        this.func_70296_d();
        this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private static class JarNetwork {
        private long lastTime = 0L;
        private List<TileJarFillable> jars = new ArrayList<TileJarFillable>();

        private JarNetwork() {
        }

        private void update() {
            long time = MinecraftServer.func_71276_C().func_130014_f_().func_82737_E();
            if (time > this.lastTime) {
                if (this.jars.size() > 1) {
                    Collections.sort(this.jars, new Comparator<TileJarFillable>(){

                        @Override
                        public int compare(TileJarFillable o1, TileJarFillable o2) {
                            return o2.amount - o1.amount;
                        }
                    });
                    TileJarFillable jar1 = this.jars.get(0);
                    if (!JarNetwork.isValid(jar1)) {
                        this.jars.remove(0);
                        return;
                    }
                    TileJarFillable jar2 = this.jars.get(this.jars.size() - 1);
                    if (!JarNetwork.isValid(jar2)) {
                        this.jars.remove(this.jars.size() - 1);
                        return;
                    }
                    if (jar2.amount + 1 < jar1.amount && jar2.addToContainer(jar1.aspect, 1) == 0) {
                        jar1.takeFromContainer(jar1.aspect, 1);
                    }
                }
                this.lastTime = time + 3L;
            }
        }

        private static boolean isValid(TileJarFillable jar) {
            return jar != null && jar.func_145831_w() != null && !jar.func_145837_r() && jar.func_145831_w().func_72899_e(jar.field_145851_c, jar.field_145848_d, jar.field_145849_e);
        }
    }
}

