/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.crafting;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import makeo.gadomancy.common.Gadomancy;
import makeo.gadomancy.common.crafting.InfusionDisguiseArmor;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.internal.DummyInternalMethodHandler;
import thaumcraft.api.internal.IInternalMethodHandler;
import thaumcraft.common.lib.research.ResearchManager;

public class InfusionVisualDisguiseArmor
extends InfusionRecipe {
    private static final IInternalMethodHandler FAKE_HANDLER = new FakeMethodHandler();
    private static final int[] POTION_METAS = new int[]{8206, 16398, 8270, 16462};
    private static ItemStack[] armorItems;
    private final ItemStack[] components;
    private final boolean transparent;

    public InfusionVisualDisguiseArmor(boolean transparent) {
        super("", (Object)new ItemStack(Blocks.field_150347_e), 0, InfusionDisguiseArmor.ASPECTS, new ItemStack(Blocks.field_150346_d), new ItemStack[0]);
        this.transparent = transparent;
        this.components = new ItemStack[InfusionDisguiseArmor.COMPONENTS.length + 1];
        System.arraycopy(InfusionDisguiseArmor.COMPONENTS, 0, this.components, 1, InfusionDisguiseArmor.COMPONENTS.length);
        if (armorItems == null && Gadomancy.proxy.getSide() == Side.CLIENT) {
            this.findArmorItems();
        }
    }

    private void findArmorItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Object o : Item.field_150901_e) {
            if (!(o instanceof Item) || ((Item)o).func_77640_w() == null) continue;
            ArrayList list = new ArrayList();
            try {
                ((Item)o).func_150895_a((Item)o, ((Item)o).func_77640_w(), list);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (Object o2 : list) {
                if (o2 == null || !(o2 instanceof ItemStack) || EntityLiving.func_82159_b((ItemStack)((ItemStack)o2)) == 0) continue;
                items.add((ItemStack)o2);
            }
        }
        armorItems = items.toArray(new ItemStack[items.size()]);
    }

    private boolean canSee(ItemStack stack) {
        String research = InfusionVisualDisguiseArmor.getResearchKey(stack);
        return research == null || ResearchManager.isResearchComplete((String)Minecraft.func_71410_x().field_71439_g.func_70005_c_(), (String)research);
    }

    public ItemStack getCurrentDisguise() {
        int next;
        if (this.transparent) {
            return new ItemStack((Item)Items.field_151068_bn, 1, POTION_METAS[(int)(System.currentTimeMillis() / 1000L % (long)POTION_METAS.length)]);
        }
        Random random = new Random(System.currentTimeMillis() / 1000L);
        int first = this.getRecipeInput(random);
        int firstPos = EntityLiving.func_82159_b((ItemStack)armorItems[first]);
        while ((next = random.nextInt(armorItems.length)) == first || EntityLiving.func_82159_b((ItemStack)armorItems[next]) != firstPos || !this.canSee(armorItems[next])) {
        }
        return armorItems[next];
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getRecipeInput() {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return new ItemStack(Items.field_151106_aX);
        }
        return armorItems[this.getRecipeInput(new Random(System.currentTimeMillis() / 1000L))];
    }

    private int getRecipeInput(Random random) {
        int index;
        while (!this.canSee(armorItems[index = random.nextInt(armorItems.length)])) {
        }
        return index;
    }

    @SideOnly(value=Side.CLIENT)
    public Object getRecipeOutput(ItemStack input) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return new ItemStack(Items.field_151106_aX);
        }
        return InfusionDisguiseArmor.disguiseStack(input, this.getCurrentDisguise());
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack[] getComponents() {
        this.components[0] = this.getCurrentDisguise();
        return this.components;
    }

    @SideOnly(value=Side.CLIENT)
    private static String getResearchKey(ItemStack stack) {
        IInternalMethodHandler old = ThaumcraftApi.internalMethods;
        ThaumcraftApi.internalMethods = FAKE_HANDLER;
        Object[] result = ThaumcraftApi.getCraftingRecipeKey((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ItemStack)stack);
        ThaumcraftApi.internalMethods = old;
        return result == null ? null : (String)result[0];
    }

    private static class FakeMethodHandler
    extends DummyInternalMethodHandler {
        private FakeMethodHandler() {
        }

        public boolean isResearchComplete(String username, String researchkey) {
            return true;
        }
    }
}

