/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.registration;

import cpw.mods.fml.common.FMLLog;
import java.lang.reflect.Field;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.potions.PotionAchromatic;
import makeo.gadomancy.common.potions.PotionBuffGolem;
import makeo.gadomancy.common.potions.PotionEldritch;
import makeo.gadomancy.common.potions.PotionMiningLuck;
import makeo.gadomancy.common.potions.PotionVisAffinity;
import makeo.gadomancy.common.utils.Injector;
import net.minecraft.potion.Potion;

public class RegisteredPotions {
    public static PotionMiningLuck POTION_LUCK;
    public static PotionBuffGolem BUFF_GOLEM;
    public static PotionAchromatic ACHROMATIC;
    public static PotionEldritch ELDRITCH;
    public static PotionVisAffinity VIS_DISCOUNT;

    public static void init() {
        POTION_LUCK = RegisteredPotions.registerPotion(PotionMiningLuck.class);
        BUFF_GOLEM = RegisteredPotions.registerPotion(PotionBuffGolem.class);
        ACHROMATIC = RegisteredPotions.registerPotion(PotionAchromatic.class);
        ELDRITCH = RegisteredPotions.registerPotion(PotionEldritch.class);
        VIS_DISCOUNT = RegisteredPotions.registerPotion(PotionVisAffinity.class);
    }

    public static void createConfigEntries() {
        for (Field field : RegisteredPotions.class.getFields()) {
            if (!Potion.class.isAssignableFrom(field.getType())) continue;
            ModConfig.loadPotionId(field.getType().getSimpleName());
        }
    }

    private static <T extends Potion> T registerPotion(Class<T> potionClass) {
        int id = ModConfig.loadPotionId(potionClass.getSimpleName());
        if (id == -1) {
            for (int i = 0; i < Potion.field_76425_a.length; ++i) {
                if (Potion.field_76425_a[i] != null) continue;
                id = i;
                break;
            }
            if (id == -1) {
                id = Potion.field_76425_a.length;
                FMLLog.warning((String)"Gadomancy could not find a free potion id and will extend the potionTypes array! This might cause fatal errors. Please consider changing the config!", (Object[])new Object[0]);
            }
        }
        if (id > 127) {
            FMLLog.warning((String)("The potion id '" + id + "' of potion '" + "Gadomancy" + ":" + potionClass.getSimpleName() + "' is bigger then 127 this might cause errors as well. Please consider changing the config."), (Object[])new Object[0]);
        }
        if (id >= Potion.field_76425_a.length) {
            Potion[] potions = new Potion[Potion.field_76425_a.length + 1];
            System.arraycopy(Potion.field_76425_a, 0, potions, 0, Potion.field_76425_a.length);
            Potion.field_76425_a = potions;
        } else if (Potion.field_76425_a[id] != null) {
            Potion conflict = Potion.field_76425_a[id];
            throw new RuntimeException("Potion id conflict! Do not report this bug you just have to change the configuration files. Failed to register potion 'Gadomancy:" + potionClass.getSimpleName() + "' with id '" + id + "'. Another potion with this id already exists: " + conflict.func_76393_a() + " (as " + conflict.getClass().getName() + ")");
        }
        return (T)((Potion)new Injector(potionClass).invokeConstructor(Integer.TYPE, (Object)id));
    }
}

