/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.utils.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import makeo.gadomancy.common.blocks.tiles.TileAdditionalEldritchPortal;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import makeo.gadomancy.common.utils.world.TCMazeSession;
import makeo.gadomancy.common.utils.world.WorldUtil;
import makeo.gadomancy.common.utils.world.fake.FakeWorldTCGeneration;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.world.dim.CellLoc;
import thaumcraft.common.lib.world.dim.GenCommon;
import thaumcraft.common.lib.world.dim.MazeHandler;
import thaumcraft.common.lib.world.dim.MazeThread;

public class TCMazeHandler {
    public static ConcurrentHashMap<CellLoc, Short> labyrinthCopy = new ConcurrentHashMap();
    public static final int TELEPORT_LAYER_Y = 55;
    private static int tickCounter = 0;
    public static final FakeWorldTCGeneration GEN = new FakeWorldTCGeneration();
    private static List<TCMazeSession> flaggedSessions = new ArrayList<TCMazeSession>();
    private static Map<EntityPlayer, TCMazeSession> runningSessions = new HashMap<EntityPlayer, TCMazeSession>();
    private static Map<TCMazeSession, Entity[]> watchedBosses = new HashMap<TCMazeSession, Entity[]>();

    public static void closeAllSessionsAndCleanup() {
        for (EntityPlayer pl : runningSessions.keySet()) {
            TCMazeSession session = runningSessions.get(pl);
            session.closeSession(false);
            watchedBosses.remove(session);
        }
        TCMazeHandler.init();
    }

    public static void tick() {
        WorldServer w = DimensionManager.getWorld((int)ModConfig.dimOuterId);
        if (w != null) {
            if (!w.field_73058_d) {
                w.field_73058_d = true;
            }
            WorldServer out = MinecraftServer.func_71276_C().func_71218_a(0);
            List playerObjects = w.field_73010_i;
            for (int i = 0; i < playerObjects.size(); ++i) {
                EntityPlayer player = (EntityPlayer)playerObjects.get(i);
                if (TCMazeHandler.hasOpenSession(player)) continue;
                WorldUtil.tryTeleportBack((EntityPlayerMP)player, 0);
                ChunkCoordinates cc = out.func_72861_E();
                int y = out.func_72825_h(cc.field_71574_a, cc.field_71573_c);
                player.func_70634_a((double)cc.field_71574_a + 0.5, (double)y, (double)cc.field_71573_c + 0.5);
            }
            Iterator<Map.Entry<EntityPlayer, TCMazeSession>> it = runningSessions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<EntityPlayer, TCMazeSession> entry = it.next();
                EntityPlayer player = entry.getKey();
                if (player.field_70170_p.field_73011_w.field_76574_g == ModConfig.dimOuterId) continue;
                entry.getValue().closeSession(false);
                it.remove();
            }
        }
    }

    public static void handleBossFinish(TCMazeSession session) {
        CellLoc spawnChunk = session.portalCell;
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(ModConfig.dimOuterId);
        int lX = (spawnChunk.x << 4) + 8;
        int lZ = (spawnChunk.z << 4) + 8;
        world.func_147465_d(lX, 52, lZ, ConfigBlocks.blockEldritch, 3, 3);
        world.func_147449_b(lX, 53, lZ, (Block)RegisteredBlocks.blockAdditionalEldrichPortal);
        GenCommon.genObelisk((World)world, (int)lX, (int)54, (int)lZ);
        session.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "" + EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"gadomancy.eldritch.portalSpawned")));
    }

    public static boolean createSessionWaitForTeleport(EntityPlayer player) {
        if (TCMazeHandler.hasOpenSession(player) || !TCMazeHandler.hasFreeSessionSpace()) {
            return false;
        }
        WorldServer w = MinecraftServer.func_71276_C().func_71218_a(ModConfig.dimOuterId);
        TCMazeHandler.reserveSessionSpace(player);
        TCMazeHandler.setupSession(player, w);
        return true;
    }

    private static void reserveSessionSpace(EntityPlayer player) {
        runningSessions.put(player, TCMazeSession.placeholder());
    }

    private static void setupSession(EntityPlayer player, WorldServer world) {
        Vec3 currentPos = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        int originDim = player.field_70170_p.field_73011_w.field_76574_g;
        Map<CellLoc, Short> locs = TCMazeHandler.calculateCellLocs(world);
        MazeBuilderThread t = new MazeBuilderThread((EntityPlayerMP)player, locs, originDim, currentPos);
        t.start();
    }

    private static Map<CellLoc, Short> calculateCellLocs(WorldServer world) {
        ConcurrentHashMap oldDat = MazeHandler.labyrinth;
        ConcurrentHashMap<CellLoc, Short> bufferOld = new ConcurrentHashMap<CellLoc, Short>(labyrinthCopy);
        MazeHandler.labyrinth = labyrinthCopy;
        int chX = TCMazeHandler.getHighestPossibleRandWH();
        int chZ = TCMazeHandler.getHighestPossibleRandWH();
        int w = TCMazeHandler.randWH(world.field_73012_v);
        int h = TCMazeHandler.randWH(world.field_73012_v);
        while (MazeHandler.mazesInRange((int)chX, (int)chZ, (int)w, (int)h)) {
            ++chX;
        }
        MazeThread mt = new MazeThread(chX, chZ, w, h, world.field_73012_v.nextLong());
        mt.run();
        Map<CellLoc, Short> locs = TCMazeHandler.calculateDifferences(bufferOld);
        labyrinthCopy = MazeHandler.labyrinth;
        MazeHandler.labyrinth = oldDat;
        return locs;
    }

    private static Map<CellLoc, Short> calculateDifferences(ConcurrentHashMap<CellLoc, Short> bufferOld) {
        ConcurrentHashMap newDat = MazeHandler.labyrinth;
        HashMap<CellLoc, Short> newlyEvaluatedMaze = new HashMap<CellLoc, Short>();
        for (CellLoc loc : newDat.keySet()) {
            if (bufferOld.containsKey(loc)) continue;
            newlyEvaluatedMaze.put(loc, (Short)newDat.get(loc));
        }
        return newlyEvaluatedMaze;
    }

    private static boolean hasFreeSessionSpace() {
        return ModConfig.maxMazeCount == -1 || runningSessions.size() < ModConfig.maxMazeCount;
    }

    private static int randWH(Random random) {
        return 17 + random.nextInt(2) * 2;
    }

    private static int getHighestPossibleRandWH() {
        return 29;
    }

    public static void init() {
        runningSessions = new HashMap<EntityPlayer, TCMazeSession>();
    }

    public static boolean hasOpenSession(EntityPlayer player) {
        return !player.field_70170_p.field_72995_K && runningSessions.get(player) != null;
    }

    public static void closeSession(EntityPlayer player, boolean teleport) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (runningSessions.containsKey(player)) {
            runningSessions.get(player).closeSession(teleport);
            runningSessions.remove(player);
        }
    }

    public static Map<EntityPlayer, TCMazeSession> getSessions() {
        return runningSessions;
    }

    public static void free(Map<CellLoc, Short> locations) {
        if (locations == null) {
            return;
        }
        for (CellLoc loc : locations.keySet()) {
            labyrinthCopy.remove(loc);
        }
    }

    public static void scheduleTick() {
        ++tickCounter;
        Iterator<TCMazeSession> it = flaggedSessions.iterator();
        while (it.hasNext()) {
            TCMazeSession s = it.next();
            it.remove();
            s.startSession();
            runningSessions.put((EntityPlayer)s.player, s);
        }
        if ((tickCounter & 0xF) == 0) {
            Iterator<Map.Entry<TCMazeSession, Entity[]>> iterator = watchedBosses.entrySet().iterator();
            block1: while (iterator.hasNext()) {
                Entity[] bosses;
                Map.Entry<TCMazeSession, Entity[]> entry = iterator.next();
                TCMazeSession session = entry.getKey();
                for (Entity entity : bosses = entry.getValue()) {
                    if (entity != null && !entity.field_70128_L) continue block1;
                }
                TCMazeHandler.handleBossFinish(session);
                iterator.remove();
            }
        }
        TCMazeHandler.tick();
    }

    public static void flagSessionForStart(TCMazeSession session) {
        flaggedSessions.add(session);
    }

    public static void putBosses(TCMazeSession session, Entity[] bosses) {
        watchedBosses.put(session, bosses);
    }

    public static class MazeBuilderThread
    extends Thread {
        private final EntityPlayerMP player;
        private final Map<CellLoc, Short> chunksAffected;
        private final int originDimId;
        private final Vec3 originLocation;

        public MazeBuilderThread(EntityPlayerMP player, Map<CellLoc, Short> chunksAffected, int originDimId, Vec3 originLocation) {
            this.player = player;
            this.chunksAffected = chunksAffected;
            this.originDimId = originDimId;
            this.originLocation = originLocation;
            this.setName("GadomancyEldritchGen (SERVER/ThreadID=" + this.getId() + ")");
        }

        @Override
        public void run() {
            ConcurrentHashMap old = MazeHandler.labyrinth;
            MazeHandler.labyrinth = labyrinthCopy;
            for (CellLoc l : this.chunksAffected.keySet()) {
                MazeHandler.generateEldritch((World)GEN, (Random)TCMazeHandler.GEN.field_73012_v, (int)l.x, (int)l.z);
            }
            MazeHandler.labyrinth = old;
            if (ModConfig.doLightCalculations) {
                for (CellLoc l : this.chunksAffected.keySet()) {
                    for (int cX = 0; cX < 16; ++cX) {
                        for (int cY = 51; cY < 61; ++cY) {
                            for (int cZ = 0; cZ < 16; ++cZ) {
                                GEN.func_147463_c(EnumSkyBlock.Block, (l.x << 4) + cX, cY, (l.z << 4) + cZ);
                            }
                        }
                    }
                }
            }
            this.finishBuild();
        }

        private void finishBuild() {
            TileAdditionalEldritchPortal.informSessionStart((EntityPlayer)this.player);
            TCMazeSession session = new TCMazeSession((EntityPlayer)this.player, this.chunksAffected, this.originDimId, this.originLocation);
            TCMazeHandler.flagSessionForStart(session);
        }
    }
}

